/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef UKCCSEARCHSESERVER_H
#define UKCCSEARCHSESERVER_H

#include <QObject>
#include <QDBusAbstractAdaptor>
#include "mainwindow.h"

class UkccSearchServer : public QDBusAbstractAdaptor //QObject
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.ukui.ukcc.search.interface")

public:
    explicit UkccSearchServer(MainWindow* parent);
    virtual ~UkccSearchServer();
    inline MainWindow *parent() const;

private:
    QTimer *m_autoExitTimer;

public Q_SLOTS:
    QVariantMap getSearchItems();
};

#endif // UKCCSEARCHSEVER_H
