% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layer.R
\docType{data}
\name{Layer-class}
\alias{Layer-class}
\alias{Layer}
\title{Layers}
\description{
The Layer class is a chaperone class not available for extension. The class
fulfils the following tasks. The class houses the Geom, Stat and Position
trinity and tracks their stateful parameters. Furthermore, its methods are
responsible for managing the layer data and exposing it to other components
of the plot at the right time.
}
\details{
The Layer class is an internal class that is not exported because the class
is not intended for extension. The \code{layer()} function instantiates the
LayerInstance class, which inherits from Layer, but has relevant fields
populated.

The class is mostly used in \code{ggplot_build()}, with the notable exception
of the \code{draw_geom()} method, which is used in \code{ggplot_gtable()} instead.
}
\section{Fields}{

\describe{
\item{\code{constructor}}{A \link[=call]{call} object with the user-facing
constructor function, for use in error messaging. This field is populated
by \code{layer()}.}

\item{\code{geom,stat,position}}{These fields house the Geom, Stat and Position
trifecta in ggproto form and is populated by \code{layer()}.}

\item{\code{stat_params,computed_stat_params}}{These fields hold parameters
assigned to the Stat. The \code{stat_params} field is directly derived from
user input and is populated by \code{layer()}. The \code{computed_stat_params}
carries state and is constructed by the \code{Stat$setup_params()} method.}

\item{\code{geom_params,computed_geom_params}}{These fields hold parameters
assigned to the Geom. The \code{geom_params} field is directly derived from
user input and is populated by \code{layer()}. The \code{computed_geom_params}
carries state and is constructed by the \code{Geom$setup_params()} method.}

\item{\code{mapping,computed_mapping}}{These fields hold \link[=aes]{mapping}s.
The \code{mapping} field holds the \code{layer(mapping)} argument. The
\code{computed_mapping} field carries state and is constructed in the
\code{setup_layer()} method.}

\item{\code{data}}{The fortified \code{layer(data)} argument.}

\item{\code{aes_params}}{Holds the fixed, unmapped aesthetics passed to
\code{layer(params)} as determined by \code{Geom$aesthetics()}.}

\item{\code{inherit.aes}}{A scalar boolean used in the \code{setup_layer()} method to
indicate whether the \code{computed_mapping} should include the global mapping
(\code{TRUE}) or only the layer mapping (\code{FALSE}). This is populated by the
\code{layer(inherit.aes)} parameter.}

\item{\code{layer_data}}{\strong{Description}

A function method for initially resolving layer data. If layer data is
missing or is a function, it will derive layer data from the global plot
data.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Layer$layer_data(plot_data)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{plot_data}}{The \code{data} field of the ggplot object.}
}

\strong{Value}

A data frame with layer data or \code{NULL}}

\item{\code{setup_layer}}{\strong{Description}

A function method is a hook to allow a final access to layer data in
input form. In addition, it allows a layer access to global plot
information. The latter is used to enforce the \code{inherit.aes} parameter by
supplementing the layer mapping with the global mapping when requested.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Layer$setup_data(data, plot)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{data}}{A data frame with the layer's data.}
\item{\code{plot}}{A ggplot object}
}

\strong{Value}

A data frame with layer data. As a side effect, the \code{computed_mapping}
field is populated.}

\item{\code{compute_aesthetics}}{\strong{Description}

A function method that evaluates aesthetics and warns about any problems.
It also infers a \code{group} aesthetic if not provided. This method is also
the step where layer data becomes standardised to base data frames without
row names or additional attributes.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Layer$compute_aesthetics(data, plot)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{data}}{A data frame with the layer's data.}
\item{\code{plot}}{A ggplot object}
}

\strong{Value}

A data frame with layer data}

\item{\code{compute_aesthetics}}{\strong{Description}

A function method that orchestrates computing statistics. It executes
methods from the Stat class to form new computed variables.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Layer$compute_statistic(data, layout)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{data}}{A data frame with the layer's data.}
\item{\code{layout}}{A \verb{<Layout>} ggproto object.}
}

\strong{Value}

A data frame with layer data. As a side effect the \code{computed_stat_params}
field is populated.}

\item{\code{map_statistic}}{\strong{Description}

A function method that finishes the result of computed statistics. It has
several tasks:
\itemize{
\item It evaluates the \code{after_stat()} stage of the mapping from both the
\code{computed_mapping} but also the \code{Stat$default_aes} fields.
\item It ensures relevant scales are instantiated for computed aesthetics.
\item It takes care that scale transformation is applied to computed aesthetics.
}

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Layer$map_statistic(data, plot)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{data}}{A data frame with the layer's data.}
\item{\code{plot}}{A ggplot object.}
}

\strong{Value}

A data frame with layer data}

\item{\code{compute_geom_1}}{\strong{Description}

A function method that prepares data for drawing. It checks that all
required aesthetics are present and sets up parameters and data using the
Geom class.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Layer$compute_geom_1(data)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{data}}{A data frame with the layer's data.}
}

\strong{Value}

A data frame with layer data. As a side effect the \code{computed_geom_params}
field is populated.}

\item{\code{compute_position}}{\strong{Description}

A function method that orchestrates the position adjustment. It executes
methods from the Position class.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Layer$compute_position(data, layout)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{data}}{A data frame with the layer's data.}
\item{\code{layout}}{A \verb{<Layout>} ggproto object.}
}

\strong{Value}

A data frame with layer data.}

\item{\code{compute_geom_2}}{\strong{Description}

A function method that add defaults and fixed parameters. It wraps the
\code{Geom$use_defaults()} method.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Layer$compute_geom_2(data, params, theme, ...)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{data}}{A data frame with the layer's data.}
\item{\code{params}}{A list with fixed aesthetic parameters, typically the
\code{aes_params} field.}
\item{\code{theme}}{A \link[=theme]{theme} object}
\item{\code{...}}{Passed on to \code{Geom$use_defaults()}, not in use.}
}

\strong{Value}

A data frame with layer data.}

\item{\code{finish_statistics}}{\strong{Description}

A function method that wraps \code{Stat$finish_layer()}.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Layer$finish_statistics(data)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{data}}{A data frame with the layer's data.}
}

\strong{Value}

A data frame with layer data.}

\item{\code{draw_geom}}{\strong{Description}

A function method that produces graphics for every panel. It uses Geom
class methods to handle missing data and produce grobs. In contrast to
other methods, this is called during the \code{ggplot_gtable()} stage, not the
\code{ggplot_build()} stage.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Layer$draw_geom(data, layout)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{data}}{A data frame with the layer's data.}
\item{\code{layout}}{A \verb{<Layout>} ggproto object.}
}

\strong{Value}

A list of grobs, one per panel.}

\item{\code{print}}{\strong{Description}

A function method that prints information about the layer.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Layer$print()
}\if{html}{\out{</div>}}

\strong{Value}

Nothing (\code{NULL}), invisibly}
}}

\section{Layer data diagram}{


As the Layer class is a chaparone for the data, it makes sense to give a
small overview of how layer data flows through a plot. In the diagram below
we following the \code{layer(data)} argument over the course of plot building
through Layer class methods. When an outside class acts on the data without
the Layer class, this is indicated with the left arrow \verb{<-}. Subcomponents
of a method that touch data are indicated with the right arrow \verb{->}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# Inside `ggplot_build()`
 |
layer(data)
 |
 |
 | # Inherit plot data
 |
Layer$layer_data()
 |
 |
 | # Finalise mapping
 |
Layer$setup_layer()
 |
 |
 | # Append PANEL variable for facets
 |
 |<- Layout$setup()
 |    |
 |    +-> Facet$setup_data()
 |    |
 |    +-> Coord$setup_data()
 |
 |
 | # Evaluate mappings to new data and infer group
 |
Layer$compute_aesthetics()
 |
 |
 | # Scale-transform all aesthetics
 |
 |<- ScalesList$transform_df()
 |    |
 |    +-> Scale$transform_df()
 |
 |
 | # Map x/y aesthetics with initial scale
 |
 |<- Layout$map_position()
 |    |
 |    +-> Scale$map()
 |
 |
 | # Compute stat part of layer
 |
Layer$compute_statistic()
 | |
 | +-> Stat$setup_data()
 | |
 | +-> Stat$compute_layer()
 |
 |
 | # Add `after_stat()` stage
 | # Scale transform computed variables
 |
Layer$map_statistic()
 |
 |
 | # Setup geom part of layer
 |
Layer$compute_geom_1()
 | |
 | +-> Geom$setup_data()
 |
 |
 | # Apply position adjustments
 |
Layer$compute_position()
 | |
 | +-> Position$use_defaults()
 | |
 | +-> Position$setup_data()
 | |
 | +-> Position$compute_layer()
 |
 |
 | # Map x/y aesthetics with final scales
 |
 |<- Layout$map_position()
 |    |
 |    +-> Scale$map()
 |
 | # Map non-position aesthetics
 |
 |<- ScalesList$map_df()
 |    |
 |    +-> Scale$map()
 |
 |
 | # Fill in defaults and fixed aesthetics
 |
Layer$compute_geom_2()
 | |
 | +-> Geom$use_defaults()
 |
 |
 | # Apply final Stat hook
 |
Layer$finish_statistics()
 | |
 | +-> Stat$finish_layer()
 |
 |
 | # Apply final Facet hook
 |
 |<- Layout$finish_data()
 |    |
 |    +-> Facet$finish_data()
 |
 V
# `ggplot_build()` is finished
# Hand off to `ggplot_gtable()`
 |
 |
 | # Draw the geom part
 |
Layer$draw_geom()
 |
 +-> Geom$handle_na()
 |
 +-> Geom$draw_layer()
}\if{html}{\out{</div>}}
}

\examples{
# None: Layer is not intended to be extended
}
\seealso{
Other Layer components: 
\code{\link{Geom}},
\code{\link{Position}},
\code{\link{Stat}}

Other chaperone classes: 
\code{\link{Layout}}
}
\concept{Layer components}
\concept{chaperone classes}
\keyword{internal}
