// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

// Generated by Fuzzlyn v2.1 on 2024-07-28 20:49:49
// Run on Arm64 Linux
// Seed: 14204794442367797079-vectort,vector64,vector128,armadvsimd,armadvsimdarm64,armaes,armarmbase,armarmbasearm64,armcrc32,armcrc32arm64,armdp,armrdm,armrdmarm64,armsha1,armsha256
// Reduced from 12.6 KiB to 0.4 KiB in 00:00:17
// Debug: Throws 'System.ArgumentOutOfRangeException'
// Release: Runs successfully
using System;
using System.Runtime.Intrinsics;
using System.Runtime.Intrinsics.Arm;
using Xunit;

public class Runtime_105621
{
    private static byte getByteImmOOB() => 9;
    private static byte getShortImmOOB() => 17;
    private static byte getLongImmOOB() => 65;

    [Fact]
    public static void TestShiftLeftLogicalByZero()
    {
        if (AdvSimd.IsSupported)
        {
            var vr3 = Vector64.Create<byte>(1);
            var vr4 = AdvSimd.ShiftLeftLogical(vr3, 0);
            Assert.Equal(vr3, vr4);
        }
    }

    [Fact]
    public static void TestShiftLeftLogicalToZero()
    {
        if (AdvSimd.IsSupported)
        {
            var vr3 = Vector64.Create<byte>(128);
            var vr4 = AdvSimd.ShiftLeftLogical(vr3, 9);
            Assert.Equal(vr4, Vector64<byte>.Zero);
        }
    }

    [Fact]
    public static void TestShiftLeftLogicalToZeroNonConst()
    {
        if (AdvSimd.IsSupported)
        {
            var vr3 = Vector64.Create<byte>(128);
            var vr4 = AdvSimd.ShiftLeftLogical(vr3, getByteImmOOB());
            Assert.Equal(vr4, Vector64<byte>.Zero);
        }
    }

    [Fact]
    public static void TestShiftLeftLogicalScalarByZero()
    {
        if (AdvSimd.IsSupported)
        {
            var vr3 = Vector64.Create<long>(1);
            var vr4 = AdvSimd.ShiftLeftLogicalScalar(vr3, 0);
            Assert.Equal(vr3, vr4);
        }
    }

    [Fact]
    public static void TestShiftLeftLogicalScalarToZero()
    {
        if (AdvSimd.IsSupported)
        {
            var vr3 = Vector64.Create<long>(128);
            var vr4 = AdvSimd.ShiftLeftLogicalScalar(vr3, 65);
            Assert.Equal(vr4, Vector64<long>.Zero);
        }
    }

    [Fact]
    public static void TestShiftLeftLogicalScalarToZeroNonConst()
    {
        if (AdvSimd.IsSupported)
        {
            var vr3 = Vector64.Create<long>(128);
            var vr4 = AdvSimd.ShiftLeftLogicalScalar(vr3, getLongImmOOB());
            Assert.Equal(vr4, Vector64<long>.Zero);
        }
    }

    [Fact]
    public static void TestShiftRightLogicalByZero()
    {
        if (AdvSimd.IsSupported)
        {
            var vr3 = Vector64.Create<byte>(1);
            var vr4 = AdvSimd.ShiftRightLogical(vr3, 0);
            Assert.Equal(vr3, vr4);
        }
    }

    [Fact]
    public static void TestShiftRightLogicalToZero()
    {
        if (AdvSimd.IsSupported)
        {
            var vr3 = Vector64.Create<byte>(128);
            var vr4 = AdvSimd.ShiftRightLogical(vr3, 9);
            Assert.Equal(vr4, Vector64<byte>.Zero);
        }
    }

    [Fact]
    public static void TestShiftRightLogicalToZeroNonConst()
    {
        if (AdvSimd.IsSupported)
        {
            var vr3 = Vector64.Create<byte>(128);
            var vr4 = AdvSimd.ShiftRightLogical(vr3, getByteImmOOB());
            Assert.Equal(vr4, Vector64<byte>.Zero);
        }
    }

    [Fact]
    public static void TestShiftRightLogicalScalarByZero()
    {
        if (AdvSimd.IsSupported)
        {
            var vr3 = Vector64.Create<long>(1);
            var vr4 = AdvSimd.ShiftRightLogicalScalar(vr3, 0);
            Assert.Equal(vr3, vr4);
        }
    }

    [Fact]
    public static void TestShiftRightLogicalScalarToZero()
    {
        if (AdvSimd.IsSupported)
        {
            var vr3 = Vector64.Create<long>(128);
            var vr4 = AdvSimd.ShiftRightLogicalScalar(vr3, 65);
            Assert.Equal(vr4, Vector64<long>.Zero);
        }
    }

    [Fact]
    public static void TestShiftRightLogicalScalarToZeroNonConst()
    {
        if (AdvSimd.IsSupported)
        {
            var vr3 = Vector64.Create<long>(128);
            var vr4 = AdvSimd.ShiftRightLogicalScalar(vr3, getLongImmOOB());
            Assert.Equal(vr4, Vector64<long>.Zero);
        }
    }

    [Fact]
    public static void TestShiftRightArithmeticByZero()
    {
        if (AdvSimd.IsSupported)
        {
            var vr3 = Vector128.Create<short>(1);
            var vr4 = AdvSimd.ShiftRightArithmetic(vr3, 0);
            Assert.Equal(vr3, vr4);
        }
    }

    [Fact]
    public static void TestShiftRightArithmeticToZero()
    {
        if (AdvSimd.IsSupported)
        {
            var vr3 = Vector128.Create<short>(128);
            var vr4 = AdvSimd.ShiftRightArithmetic(vr3, 17);
            Assert.Equal(vr4, Vector128<short>.Zero);
        }
    }

    [Fact]
    public static void TestShiftRightArithmeticToZeroNonConst()
    {
        if (AdvSimd.IsSupported)
        {
            var vr3 = Vector128.Create<short>(128);
            var vr4 = AdvSimd.ShiftRightArithmetic(vr3, getShortImmOOB());
            Assert.Equal(vr4, Vector128<short>.Zero);
        }
    }

    [Fact]
    public static void TestShiftRightArithmeticScalarByZero()
    {
        if (AdvSimd.IsSupported)
        {
            var vr3 = Vector64.Create<long>(1);
            var vr4 = AdvSimd.ShiftRightArithmeticScalar(vr3, 0);
            Assert.Equal(vr3, vr4);
        }
    }

    [Fact]
    public static void TestShiftRightArithmeticScalarToZero()
    {
        if (AdvSimd.IsSupported)
        {
            var vr3 = Vector64.Create<long>(128);
            var vr4 = AdvSimd.ShiftRightArithmeticScalar(vr3, 65);
            Assert.Equal(vr4, Vector64<long>.Zero);
        }
    }

    [Fact]
    public static void TestShiftRightArithmeticScalarToZeroNonConst()
    {
        if (AdvSimd.IsSupported)
        {
            var vr3 = Vector64.Create<long>(128);
            var vr4 = AdvSimd.ShiftRightArithmeticScalar(vr3, getLongImmOOB());
            Assert.Equal(vr4, Vector64<long>.Zero);
        }
    }
}
