/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.laf.debug;

import com.bulenkov.darcula.DarculaLaf;
import com.paterva.maltego.util.ColorUtilities;
import com.paterva.maltego.util.ui.WindowUtil;
import com.paterva.maltego.util.ui.components.LabelWithBackground;
import com.paterva.maltego.util.ui.laf.MaltegoLAF;
import com.paterva.maltego.util.ui.laf.MaltegoLAFRefresh;
import com.paterva.maltego.util.ui.laf.debug.GeneratedPropertiesPanel;
import com.paterva.maltego.util.ui.laf.debug.MaltegoLAFDebug;
import com.paterva.maltego.util.ui.laf.debug.MaltegoLAFTableModel;
import com.paterva.maltego.util.ui.laf.debug.SafeIcon;
import com.paterva.maltego.util.ui.laf.debug.UIManagerLafDefaultsTableModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.Painter;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ColorUIResource;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.apache.commons.io.IOUtils;
import org.netbeans.swing.etable.ETable;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class MaltegoLAFDebugPanel
extends JPanel {
    private static final String PREF_FILTER = "maltego.laf.debug.filter";
    private static final String MALTEGO_PROPS = "maltego bundle";
    private final MaltegoLAFTableModel _model = new MaltegoLAFTableModel();
    private final TreeMap<String, TreeMap<String, Object>> _items = new TreeMap();
    private final HashMap<String, AbstractTableModel> _models = new HashMap();
    private static String _selectedItem;
    private boolean allowComboBoxActions = true;
    private static final char[] hexDigit;
    private JRadioButton _byComponent;
    private JRadioButton _byValueType;
    private JComboBox _comboBox;
    private JButton _compileButton;
    private JButton _filterButton;
    private JTextField _filterTextField;
    private JButton _generateButton;
    private JTextField _keyTextField;
    private JButton _loadButton;
    private ETable _propertyTable;
    private JButton _resetButton;
    private JButton _resetOneButton;
    private JButton _updateButton;
    private JTextField _valueTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane2;

    public MaltegoLAFDebugPanel() {
        WindowUtil.showWaitCursor();
        this.initComponents();
        this._propertyTable.setModel((TableModel)this._model);
        this._propertyTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (MaltegoLAFDebugPanel.this._propertyTable.getModel() instanceof UIManagerLafDefaultsTableModel) {
                    UIManagerLafDefaultsTableModel model = (UIManagerLafDefaultsTableModel)MaltegoLAFDebugPanel.this._propertyTable.getModel();
                    int row = MaltegoLAFDebugPanel.this._propertyTable.getSelectedRow();
                    if (row != -1) {
                        String key = (String)model.getValueAt(row, 0);
                        MaltegoLAFDebugPanel.this._keyTextField.setText(key);
                    }
                } else {
                    String key = MaltegoLAFDebugPanel.this.getSelectedKey();
                    if (key != null) {
                        String value = MaltegoLAF.getDefault().getRawString(key);
                        MaltegoLAFDebugPanel.this._keyTextField.setText(key);
                        MaltegoLAFDebugPanel.this._valueTextField.setText(value);
                    }
                }
            }
        });
        this._propertyTable.setAutoCreateColumnsFromModel(false);
        this.setTablePreferredWidth();
        this._propertyTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JTable target = (JTable)e.getSource();
                int row = target.getSelectedRow();
                int column = target.getSelectedColumn();
                if (column == 2) {
                    if (MaltegoLAFDebugPanel.this._propertyTable.getModel() instanceof UIManagerLafDefaultsTableModel) {
                        UIManagerLafDefaultsTableModel model = (UIManagerLafDefaultsTableModel)MaltegoLAFDebugPanel.this._models.get(_selectedItem);
                        String key = (String)model.getValueAt(row, 0);
                        Map attributes = (Map)MaltegoLAFDebugPanel.this._items.get(_selectedItem);
                        Object value = attributes.get(key);
                        if (value instanceof Color) {
                            Color color = (Color)value;
                            MaltegoLAFDebugPanel.this.createColorPickerPopup(key, color, true, row);
                        }
                    } else {
                        int modelIndex = MaltegoLAFDebugPanel.this._propertyTable.convertRowIndexToModel(row);
                        String key = MaltegoLAFDebugPanel.this._model.getKey(modelIndex);
                        Color color = MaltegoLAFDebugPanel.this._model.getColor(key);
                        if (!color.equals(MaltegoLAFTableModel.NOT_A_COLOR)) {
                            MaltegoLAFDebugPanel.this.createColorPickerPopup(key, color, false, -1);
                        }
                    }
                }
            }
        });
        String filter = NbPreferences.forModule(this.getClass()).get(PREF_FILTER, "");
        this._model.setFilter(filter);
        this._filterTextField.setText(filter);
        ButtonGroup group = new ButtonGroup();
        group.add(this._byComponent);
        group.add(this._byValueType);
        this._byComponent.doClick();
        this._comboBox.setSelectedItem(MALTEGO_PROPS);
        WindowUtil.hideWaitCursor();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WindowUtil.showWaitCursor(MaltegoLAFDebugPanel.this);
                DarculaLaf.darculaTempCompiledPropertiesString = MaltegoLAFDebugPanel.updatePropertiesCompiled(DarculaLaf.darculaTempCompiledPropertiesString, "");
                MaltegoLAFRefresh.getDefault().refresh(false);
                WindowUtil.hideWaitCursor(MaltegoLAFDebugPanel.this);
            }
        });
    }

    private void setTablePreferredWidth() {
        TableColumnModel columnModel = this._propertyTable.getColumnModel();
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            columnModel.getColumn(i).setPreferredWidth(300);
        }
        columnModel.getColumn(2).setCellRenderer(new SampleRenderer(true));
    }

    private void createColorPickerPopup(String key, Color color, boolean fromUIManagerLafDefaults, int row) {
        JColorChooser colorChooser = new JColorChooser(color);
        Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)new DialogDescriptor((Object)colorChooser, "Select color"));
        if (DialogDescriptor.OK_OPTION.equals(result)) {
            color = colorChooser.getColor();
            int alpha = color.getAlpha();
            String value = ColorUtilities.encode((Color)color).toUpperCase();
            if (alpha != 255) {
                value = value + String.format("%02X", alpha).toUpperCase();
            }
            if (fromUIManagerLafDefaults) {
                Map attributes = this._items.get(_selectedItem);
                attributes.put(key, color);
                UIManagerLafDefaultsTableModel model = (UIManagerLafDefaultsTableModel)this._models.get(_selectedItem);
                model.setValueAt(new ColorUIResource(color).toString(), row, 1);
                model.setValueAt(color, row, 2);
            }
            this.update(key, value);
        }
    }

    private void changeTableModel(String itemName) {
        AbstractTableModel modelFromModels = this._models.get(itemName);
        if (modelFromModels != null) {
            if (modelFromModels instanceof UIManagerLafDefaultsTableModel) {
                UIManagerLafDefaultsTableModel model = (UIManagerLafDefaultsTableModel)modelFromModels;
                this._propertyTable.setModel((TableModel)model);
            } else {
                this._propertyTable.setModel((TableModel)modelFromModels);
            }
            return;
        }
        if (!MALTEGO_PROPS.equals(itemName)) {
            UIManagerLafDefaultsTableModel model = new UIManagerLafDefaultsTableModel(MaltegoLAFTableModel.COLUMNS, 0);
            Map attributes = this._items.get(itemName);
            for (String attribute : attributes.keySet()) {
                Object value = attributes.get(attribute);
                Vector<String> row = new Vector<String>(3);
                row.add(attribute);
                if (value != null) {
                    row.add(value.toString());
                    if (value instanceof Icon) {
                        value = new SafeIcon((Icon)value);
                    }
                    row.add((String)value);
                } else {
                    row.add("null");
                    row.add("");
                }
                model.addRow(row);
            }
            this._propertyTable.setModel((TableModel)model);
            this._models.put(itemName, model);
        } else {
            this._propertyTable.setModel((TableModel)this._model);
            this._models.put(itemName, this._model);
        }
    }

    private void updateRowHeights() {
        try {
            for (int row = 0; row < this._propertyTable.getRowCount(); ++row) {
                int rowHeight = this._propertyTable.getRowHeight();
                for (int column = 0; column < this._propertyTable.getColumnCount(); ++column) {
                    Component comp = this._propertyTable.prepareRenderer(this._propertyTable.getCellRenderer(row, column), row, column);
                    rowHeight = Math.max(rowHeight, comp.getPreferredSize().height);
                }
                this._propertyTable.setRowHeight(row, rowHeight);
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public void resetUIManagerLafDefaultsComponents() {
        this._items.clear();
        this._models.clear();
        if (this._propertyTable.getModel() instanceof UIManagerLafDefaultsTableModel) {
            ((UIManagerLafDefaultsTableModel)this._propertyTable.getModel()).setRowCount(0);
        }
        this.buildItemsMap();
        Vector<String> comboBoxItems = new Vector<String>(50);
        for (String key : this._items.keySet()) {
            comboBoxItems.add(key);
        }
        this.allowComboBoxActions = false;
        this._comboBox.setModel(new DefaultComboBoxModel(comboBoxItems));
        this._comboBox.setSelectedIndex(-1);
        this.allowComboBoxActions = true;
        this._comboBox.requestFocusInWindow();
        if (_selectedItem != null) {
            this._comboBox.setSelectedItem(_selectedItem);
        }
    }

    private TreeMap buildItemsMap() {
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        Enumeration enumm = defaults.keys();
        while (enumm.hasMoreElements()) {
            Object key = enumm.nextElement();
            Object value = defaults.get(key);
            String itemName = this.getItemName(key.toString(), value);
            if (itemName == null || MALTEGO_PROPS.equals(itemName)) continue;
            TreeMap<String, Object> attributeMap = this._items.get(itemName);
            if (attributeMap == null) {
                attributeMap = new TreeMap();
                this._items.put(itemName, attributeMap);
            }
            attributeMap.put(key.toString(), value);
        }
        this._items.put(MALTEGO_PROPS, null);
        return this._items;
    }

    private String getItemName(String key, Object value) {
        if (key.startsWith("class") || key.startsWith("javax")) {
            return null;
        }
        if (this._byComponent.isSelected()) {
            return MaltegoLAFDebugPanel.getComponentName(key, value);
        }
        return this.getValueName(key, value);
    }

    public static String getComponentName(String key, Object value) {
        int pos = MaltegoLAFDebugPanel.componentNameEndOffset(key);
        String componentName = pos != -1 ? key.substring(0, pos) : (key.endsWith("UI") ? key.substring(0, key.length() - 2) : (key.contains("-") ? MALTEGO_PROPS : (value instanceof Color ? "system colors" : "miscellaneous")));
        if (componentName.equals("Checkbox")) {
            componentName = "CheckBox";
        }
        return componentName;
    }

    public static int componentNameEndOffset(String key) {
        if (key.startsWith("\"")) {
            return key.indexOf("\"", 1) + 1;
        }
        int pos = key.indexOf(":");
        if (pos != -1) {
            return pos;
        }
        pos = key.indexOf("[");
        if (pos != -1) {
            return pos;
        }
        return key.indexOf(".");
    }

    private String getValueName(String key, Object value) {
        if (value instanceof Icon) {
            return "Icon";
        }
        if (value instanceof Font) {
            return "Font";
        }
        if (value instanceof Border) {
            return "Border";
        }
        if (value instanceof Color) {
            return "Color";
        }
        if (value instanceof Insets) {
            return "Insets";
        }
        if (value instanceof Boolean) {
            return "Boolean";
        }
        if (value instanceof Dimension) {
            return "Dimension";
        }
        if (value instanceof Number) {
            return "Number";
        }
        if (value instanceof Painter) {
            return "Painter";
        }
        if (key.endsWith("UI")) {
            return "UI";
        }
        if (key.endsWith("InputMap")) {
            return "InputMap";
        }
        if (key.endsWith("RightToLeft")) {
            return "InputMap";
        }
        if (key.endsWith("radient")) {
            return "Gradient";
        }
        return "The Rest";
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        MaltegoLAFDebug.save();
    }

    private String getSelectedKey() {
        int modelIndex = this._propertyTable.convertRowIndexToModel(this._propertyTable.getSelectedRow());
        return modelIndex < 0 ? null : this._model.getKey(modelIndex);
    }

    private String updateProperties(String propertiesString) {
        MaltegoLAF laf = MaltegoLAF.getDefault();
        Set<String> keys = laf.getKeys();
        for (String key : keys) {
            String value = laf.getRawString(key);
            String pattern = String.format("\\b(%s=)[^\\n]*", key);
            Matcher m1 = Pattern.compile(pattern).matcher(propertiesString);
            if (m1.find()) {
                propertiesString = propertiesString.replaceFirst(pattern, "$1" + Matcher.quoteReplacement(MaltegoLAFDebugPanel.saveConvert(value, false, true)));
                continue;
            }
            propertiesString = propertiesString.concat(System.getProperty("line.separator") + key + "=" + value);
        }
        return propertiesString;
    }

    public static String updatePropertiesCompiled(String propertiesString, String removeKey) {
        MaltegoLAF laf = MaltegoLAF.getDefault();
        Set<String> keys = laf.getKeys();
        for (String key : keys) {
            String value = laf.getCompiledString(key);
            String pattern = String.format("\\b(%s=)[^\\n]*", key);
            Matcher m1 = Pattern.compile(pattern).matcher(propertiesString);
            if (m1.find()) {
                propertiesString = propertiesString.replaceFirst(pattern, "$1" + Matcher.quoteReplacement(MaltegoLAFDebugPanel.saveConvert(value, false, true)));
                continue;
            }
            propertiesString = propertiesString.concat(System.getProperty("line.separator") + key + "=" + value);
        }
        if (!removeKey.isEmpty()) {
            String pattern = String.format("\\b(%s=)[^\\n]*", removeKey);
            ClassLoader classloader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            InputStream is = classloader.getResourceAsStream("com/paterva/maltego/util/ui/laf/Bundle.properties");
            try {
                String properties = IOUtils.toString((InputStream)is, (String)"UTF-8");
                Matcher m2 = Pattern.compile(pattern).matcher(properties);
                if (!m2.find()) {
                    propertiesString = propertiesString.replaceFirst(".*" + removeKey + ".*(\\r?\\n|\\r)?", "");
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return propertiesString;
    }

    private static String saveConvert(String theString, boolean escapeSpace, boolean escapeUnicode) {
        int len = theString.length();
        int bufLen = len * 2;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuffer outBuffer = new StringBuffer(bufLen);
        block8: for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue;
                }
                outBuffer.append(aChar);
                continue;
            }
            switch (aChar) {
                case ' ': {
                    if (x == 0 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                case '!': 
                case ':': 
                case '=': {
                    outBuffer.append('\\');
                    outBuffer.append(aChar);
                    continue block8;
                }
                default: {
                    if ((aChar < ' ' || aChar > '~') && escapeUnicode) {
                        outBuffer.append('\\');
                        outBuffer.append('u');
                        outBuffer.append(MaltegoLAFDebugPanel.toHex(aChar >> 12 & 0xF));
                        outBuffer.append(MaltegoLAFDebugPanel.toHex(aChar >> 8 & 0xF));
                        outBuffer.append(MaltegoLAFDebugPanel.toHex(aChar >> 4 & 0xF));
                        outBuffer.append(MaltegoLAFDebugPanel.toHex(aChar & 0xF));
                        continue block8;
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    private void update(String key, String value) {
        WindowUtil.showWaitCursor(this);
        MaltegoLAF.getDefault().setRawString(key, value);
        DarculaLaf.darculaTempCompiledPropertiesString = MaltegoLAFDebugPanel.updatePropertiesCompiled(DarculaLaf.darculaTempCompiledPropertiesString, "");
        this.updateTableLayout();
        MaltegoLAFRefresh.getDefault().refresh(false);
        WindowUtil.hideWaitCursor(this);
    }

    private void updateTableLayout() {
        if (_selectedItem != null) {
            this._models.get(_selectedItem).fireTableDataChanged();
            this.updateRowHeights();
        }
    }

    private void initComponents() {
        this.jLabel2 = new LabelWithBackground();
        this.jLabel3 = new LabelWithBackground();
        this._keyTextField = new JTextField();
        this._valueTextField = new JTextField();
        this._updateButton = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this._propertyTable = new ETable();
        this._resetOneButton = new JButton();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel4 = new JLabel();
        this._generateButton = new JButton();
        this._resetButton = new JButton();
        this._loadButton = new JButton();
        this._compileButton = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabel5 = new LabelWithBackground();
        this._filterTextField = new JTextField();
        this._filterButton = new JButton();
        this.jPanel3 = new JPanel();
        this._comboBox = new JComboBox();
        this._byComponent = new JRadioButton();
        this._byValueType = new JRadioButton();
        this.jLabel6 = new LabelWithBackground();
        this.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.setPreferredSize(new Dimension(800, 600));
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(MaltegoLAFDebugPanel.class, (String)"MaltegoLAFDebugPanel.jLabel2.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 6, 6, 0);
        this.add((Component)this.jLabel2, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(MaltegoLAFDebugPanel.class, (String)"MaltegoLAFDebugPanel.jLabel3.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 6, 6, 0);
        this.add((Component)this.jLabel3, gridBagConstraints);
        this._keyTextField.setEditable(false);
        this._keyTextField.setText(NbBundle.getMessage(MaltegoLAFDebugPanel.class, (String)"MaltegoLAFDebugPanel._keyTextField.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 6, 6);
        this.add((Component)this._keyTextField, gridBagConstraints);
        this._valueTextField.setText(NbBundle.getMessage(MaltegoLAFDebugPanel.class, (String)"MaltegoLAFDebugPanel._valueTextField.text"));
        this._valueTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MaltegoLAFDebugPanel.this._valueTextFieldActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 6, 6);
        this.add((Component)this._valueTextField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this._updateButton, (String)NbBundle.getMessage(MaltegoLAFDebugPanel.class, (String)"MaltegoLAFDebugPanel._updateButton.text"));
        this._updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MaltegoLAFDebugPanel.this._updateButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.add((Component)this._updateButton, gridBagConstraints);
        this._propertyTable.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null, null, null, null}, {null, null, null, null, null}, {null, null, null, null, null}, {null, null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4", "Title 5"}));
        this._propertyTable.setFillsViewportHeight(true);
        this._propertyTable.setRowHeight(20);
        this.jScrollPane2.setViewportView((Component)this._propertyTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.add((Component)this.jScrollPane2, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this._resetOneButton, (String)NbBundle.getMessage(MaltegoLAFDebugPanel.class, (String)"MaltegoLAFDebugPanel._resetOneButton.text"));
        this._resetOneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MaltegoLAFDebugPanel.this._resetOneButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.add((Component)this._resetOneButton, gridBagConstraints);
        this.jPanel1.setMinimumSize(new Dimension(561, 80));
        this.jPanel1.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(MaltegoLAFDebugPanel.class, (String)"MaltegoLAFDebugPanel.jLabel1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 6, 3, 6);
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(MaltegoLAFDebugPanel.class, (String)"MaltegoLAFDebugPanel.jLabel4.text"));
        this.jLabel4.setPreferredSize(new Dimension(450, 14));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 6, 3, 6);
        this.jPanel1.add((Component)this.jLabel4, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this._generateButton, (String)NbBundle.getMessage(MaltegoLAFDebugPanel.class, (String)"MaltegoLAFDebugPanel._generateButton.text"));
        this._generateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MaltegoLAFDebugPanel.this._generateButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.jPanel1.add((Component)this._generateButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this._resetButton, (String)NbBundle.getMessage(MaltegoLAFDebugPanel.class, (String)"MaltegoLAFDebugPanel._resetButton.text"));
        this._resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MaltegoLAFDebugPanel.this._resetButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.jPanel1.add((Component)this._resetButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this._loadButton, (String)NbBundle.getMessage(MaltegoLAFDebugPanel.class, (String)"MaltegoLAFDebugPanel._loadButton.text"));
        this._loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MaltegoLAFDebugPanel.this._loadButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.jPanel1.add((Component)this._loadButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this._compileButton, (String)NbBundle.getMessage(MaltegoLAFDebugPanel.class, (String)"MaltegoLAFDebugPanel._compileButton.text"));
        this._compileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MaltegoLAFDebugPanel.this._compileButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        this.jPanel1.add((Component)this._compileButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel5.setText(NbBundle.getMessage(MaltegoLAFDebugPanel.class, (String)"MaltegoLAFDebugPanel.jLabel5.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.jPanel2.add((Component)this.jLabel5, gridBagConstraints);
        this._filterTextField.setText(NbBundle.getMessage(MaltegoLAFDebugPanel.class, (String)"MaltegoLAFDebugPanel._filterTextField.text"));
        this._filterTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MaltegoLAFDebugPanel.this._filterTextFieldActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.jPanel2.add((Component)this._filterTextField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this._filterButton, (String)NbBundle.getMessage(MaltegoLAFDebugPanel.class, (String)"MaltegoLAFDebugPanel._filterButton.text"));
        this._filterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MaltegoLAFDebugPanel.this._filterButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        this.jPanel2.add((Component)this._filterButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this._comboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this._comboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MaltegoLAFDebugPanel.this._comboBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 0, 6, 0);
        this.jPanel3.add((Component)this._comboBox, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this._byComponent, (String)NbBundle.getMessage(MaltegoLAFDebugPanel.class, (String)"MaltegoLAFDebugPanel._byComponent.text"));
        this._byComponent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MaltegoLAFDebugPanel.this._byComponentActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(6, 0, 6, 0);
        this.jPanel3.add((Component)this._byComponent, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this._byValueType, (String)NbBundle.getMessage(MaltegoLAFDebugPanel.class, (String)"MaltegoLAFDebugPanel._byValueType.text"));
        this._byValueType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MaltegoLAFDebugPanel.this._byValueTypeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(6, 0, 6, 0);
        this.jPanel3.add((Component)this._byValueType, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(MaltegoLAFDebugPanel.class, (String)"MaltegoLAFDebugPanel.jLabel6.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 0, 6, 0);
        this.jPanel3.add((Component)this.jLabel6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.add((Component)this.jPanel3, gridBagConstraints);
    }

    private void _updateButtonActionPerformed(ActionEvent evt) {
        String key = this._keyTextField.getText();
        String value = this._valueTextField.getText();
        this.update(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _generateButtonActionPerformed(ActionEvent evt) {
        try {
            WindowUtil.showWaitCursor(this);
            ClassLoader classloader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            InputStream is = classloader.getResourceAsStream("com/paterva/maltego/util/ui/laf/Bundle.properties");
            String properties = IOUtils.toString((InputStream)is, (String)"UTF-8");
            properties = this.updateProperties(properties);
            GeneratedPropertiesPanel panel = new GeneratedPropertiesPanel(properties);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new DialogDescriptor((Object)panel, "Bundle.properties"));
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            WindowUtil.hideWaitCursor(this);
        }
    }

    private void _resetButtonActionPerformed(ActionEvent evt) {
        WindowUtil.showWaitCursor(this);
        MaltegoLAFDebug.reset();
        DarculaLaf.darculaTempCompiledPropertiesString = "";
        MaltegoLAFRefresh.getDefault().refresh(false);
        this.resetUIManagerLafDefaultsComponents();
        this.updateTableLayout();
        WindowUtil.hideWaitCursor(this);
    }

    private void _resetOneButtonActionPerformed(ActionEvent evt) {
        WindowUtil.showWaitCursor(this);
        String key = this._keyTextField.getText();
        if (MaltegoLAF.getDefault().getKeys().contains(key)) {
            MaltegoLAF.getDefault().reset(key);
            DarculaLaf.darculaTempCompiledPropertiesString = MaltegoLAFDebugPanel.updatePropertiesCompiled(DarculaLaf.darculaTempCompiledPropertiesString, key);
            MaltegoLAFRefresh.getDefault().refresh(false);
            if (this._propertyTable.getModel() instanceof UIManagerLafDefaultsTableModel) {
                Map attributes = this._items.get(_selectedItem);
                Color color = UIManager.getLookAndFeelDefaults().getColor(key);
                attributes.put(key, attributes.put(key, color));
                UIManagerLafDefaultsTableModel model = (UIManagerLafDefaultsTableModel)this._models.get(_selectedItem);
                model.setValueAt(new ColorUIResource(color).toString(), this._propertyTable.getSelectedRow(), 1);
                model.setValueAt(color, this._propertyTable.getSelectedRow(), 2);
            }
            this.updateTableLayout();
        }
        WindowUtil.hideWaitCursor(this);
    }

    private void _filterButtonActionPerformed(ActionEvent evt) {
        WindowUtil.showWaitCursor(this);
        String text = this._filterTextField.getText();
        NbPreferences.forModule(this.getClass()).put(PREF_FILTER, text);
        this._model.setFilter(text);
        this.updateTableLayout();
        WindowUtil.hideWaitCursor(this);
    }

    private void _filterTextFieldActionPerformed(ActionEvent evt) {
        this._filterButton.doClick();
    }

    private void _valueTextFieldActionPerformed(ActionEvent evt) {
        this._updateButton.doClick();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _loadButtonActionPerformed(ActionEvent evt) {
        try {
            WindowUtil.showWaitCursor(this);
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setCurrentDirectory(MaltegoLAFDebug.getDir());
            fileChooser.setSelectedFile(new File("Bundle.properties"));
            if (0 == fileChooser.showOpenDialog(this)) {
                this._resetButton.doClick();
                File selectedFile = fileChooser.getSelectedFile();
                Properties properties = new Properties();
                properties.load(new FileInputStream(selectedFile));
                MaltegoLAF laf = MaltegoLAF.getDefault();
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    laf.setRawString(key, value);
                }
                DarculaLaf.darculaTempCompiledPropertiesString = MaltegoLAFDebugPanel.updatePropertiesCompiled(DarculaLaf.darculaTempCompiledPropertiesString, "");
                this.updateTableLayout();
                MaltegoLAFRefresh.getDefault().refresh(false);
                MaltegoLAFDebug.setDir(fileChooser.getCurrentDirectory());
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            WindowUtil.hideWaitCursor(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _compileButtonActionPerformed(ActionEvent evt) {
        try {
            WindowUtil.showWaitCursor(this);
            ClassLoader classloader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            InputStream is = classloader.getResourceAsStream("com/paterva/maltego/util/ui/laf/Bundle.properties");
            String properties = IOUtils.toString((InputStream)is, (String)"UTF-8");
            properties = MaltegoLAFDebugPanel.updatePropertiesCompiled(properties, "");
            GeneratedPropertiesPanel panel = new GeneratedPropertiesPanel(properties);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new DialogDescriptor((Object)panel, "Bundle.properties"));
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            WindowUtil.hideWaitCursor(this);
        }
    }

    private void _byComponentActionPerformed(ActionEvent evt) {
        _selectedItem = null;
        this.resetUIManagerLafDefaultsComponents();
        this._comboBox.requestFocusInWindow();
    }

    private void _byValueTypeActionPerformed(ActionEvent evt) {
        _selectedItem = null;
        this.resetUIManagerLafDefaultsComponents();
        this._comboBox.requestFocusInWindow();
    }

    private void _comboBoxItemStateChanged(ItemEvent evt) {
        if (this.allowComboBoxActions && evt.getStateChange() == 1) {
            String itemName = (String)evt.getItem();
            this._propertyTable.clearSelection();
            this.changeTableModel(itemName);
            this.updateRowHeights();
            this.setTablePreferredWidth();
            _selectedItem = itemName;
            if (!MALTEGO_PROPS.equals(itemName)) {
                this._updateButton.setEnabled(false);
                this._keyTextField.setText("");
                this._valueTextField.setText("");
                this._keyTextField.setEnabled(false);
                this._valueTextField.setEnabled(false);
                this._filterTextField.setEnabled(false);
                this._filterButton.setEnabled(false);
            } else {
                this._filterTextField.setEnabled(true);
                this._filterButton.setEnabled(true);
                this._updateButton.setEnabled(true);
                this._keyTextField.setEnabled(true);
                this._valueTextField.setEnabled(true);
            }
        }
    }

    static {
        hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }

    static class SampleRenderer
    extends JPanel
    implements TableCellRenderer {
        Border unselectedBorder = null;
        Border selectedBorder = null;
        boolean isBordered = true;
        private final JLabel _hex = new JLabel();
        private final JLabel _dec = new JLabel();

        public SampleRenderer(boolean isBordered) {
            this.isBordered = isBordered;
            this.setOpaque(true);
            Font font = new Font("Monospaced", 0, new JLabel().getFont().getSize() - 1);
            this._hex.setFont(font);
            this._dec.setFont(font);
            this.setLayout(new BorderLayout());
            this.add((Component)this._hex, "West");
            this.add(this._dec);
            this._hex.setHorizontalAlignment(2);
            this._dec.setHorizontalAlignment(4);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object sample, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setBackground(null);
            this.setBorder(null);
            Font font = new Font("Monospaced", 0, new JLabel().getFont().getSize() - 1);
            this._hex.setFont(font);
            this._hex.setText("");
            this._dec.setText("");
            this._hex.setIcon(null);
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            }
            if (sample instanceof Color) {
                Color newColor = (Color)sample;
                if (!newColor.equals(MaltegoLAFTableModel.NOT_A_COLOR)) {
                    this.setBackground(newColor);
                    if (this.isBordered) {
                        if (isSelected) {
                            if (this.selectedBorder == null) {
                                this.selectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getSelectionBackground());
                            }
                            this.setBorder(this.selectedBorder);
                        } else {
                            if (this.unselectedBorder == null) {
                                this.unselectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getBackground());
                            }
                            this.setBorder(this.unselectedBorder);
                        }
                    }
                    int red = newColor.getRed();
                    int green = newColor.getGreen();
                    int blue = newColor.getBlue();
                    int alpha = newColor.getAlpha();
                    if (red == 0 && green == 0 && blue == 0 && alpha == 0) {
                        this._hex.setText("");
                        this._dec.setText("");
                    } else {
                        Color fg = this.invert(newColor);
                        String txt = ColorUtilities.encode((Color)newColor).toUpperCase();
                        txt = txt + String.format(" %02X", alpha);
                        this._hex.setForeground(fg);
                        this._hex.setText(txt);
                        txt = String.format("%03d,%03d,%03d,%03d", red, green, blue, alpha);
                        this._dec.setForeground(fg);
                        this._dec.setText(txt);
                    }
                }
            } else if (sample instanceof Border) {
                this.setBorder((Border)sample);
            } else if (sample instanceof Font) {
                this._hex.setText("Sample");
                this._hex.setFont((Font)sample);
            } else if (sample instanceof Icon) {
                this._hex.setIcon((Icon)sample);
            }
            return this;
        }

        private Color invert(Color c) {
            float[] hsb = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
            hsb[1] = Math.min(hsb[1], 0.1f);
            hsb[2] = (double)hsb[2] < 0.6 || c.getRed() < 50 && c.getGreen() < 50 ? 0.9f : 0.1f;
            return Color.getHSBColor(hsb[0], hsb[1], hsb[2]);
        }

        @Override
        public void paint(Graphics g) {
            try {
                super.paint(g);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

