/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb.client;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.BufferUnderflowException;
import java.nio.channels.ClosedChannelException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.xlightweb.HttpRequest;
import org.xlightweb.HttpRequestHeaderWrapper;
import org.xlightweb.HttpUtils;
import org.xlightweb.IHttpExchange;
import org.xlightweb.IHttpRequest;
import org.xlightweb.IHttpRequestHandler;
import org.xlightweb.IHttpRequestHeader;
import org.xlightweb.IHttpResponse;
import org.xlightweb.IHttpResponseHandler;
import org.xlightweb.client.HttpClientConnection;
import org.xsocket.Execution;
import org.xsocket.MaxReadSizeExceededException;
import org.xsocket.connection.IDataHandler;
import org.xsocket.connection.IHandler;
import org.xsocket.connection.INonBlockingConnection;
import org.xsocket.connection.NonBlockingConnection;

final class ProxyHandler
implements IHttpRequestHandler {
    private static final Logger LOG = Logger.getLogger(ProxyHandler.class.getName());
    private String proxyHost;
    private int proxyPort = -1;
    private String securedProxyHost;
    private int securedProxyPort = -1;
    private String proxyUser;
    private String proxyPassword;
    private String proxyUserPassword;
    private SSLContext sslContext;

    ProxyHandler() {
    }

    public void setSSLContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public void setSecuredProxyHost(String host) {
        if (host != null && host.length() == 0) {
            host = null;
        }
        this.securedProxyHost = host;
    }

    public void setSecuredProxyPort(int proxyPort) {
        this.securedProxyPort = proxyPort;
    }

    public void setProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
        if (this.proxyPassword != null) {
            try {
                this.proxyUserPassword = new String(HttpUtils.encodeBase64((proxyUser + ":" + this.proxyPassword).getBytes()));
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe.toString());
            }
        }
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
        if (this.proxyUser != null) {
            try {
                this.proxyUserPassword = new String(HttpUtils.encodeBase64((this.proxyUser + ":" + proxyPassword).getBytes()));
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe.toString());
            }
        }
    }

    public void setProxyHost(String host) {
        if (host != null && host.length() == 0) {
            host = null;
        }
        this.proxyHost = host;
    }

    @Execution(value=0)
    public void onRequest(IHttpExchange exchange) throws IOException {
        IHttpRequest request = exchange.getRequest();
        if (!this.hasProxytoUse(request)) {
            exchange.forward(request);
            return;
        }
        if (request.isSecure()) {
            this.forwardSSL(exchange);
        } else {
            this.forwardNonSSL(exchange);
        }
    }

    private boolean hasProxytoUse(IHttpRequest request) {
        if (!request.isSecure() && this.proxyHost == null) {
            return false;
        }
        return !request.isSecure() || this.securedProxyHost != null;
    }

    private void forwardNonSSL(IHttpExchange exchange) throws IOException {
        IHttpRequest request = exchange.getRequest();
        if (this.proxyUser != null) {
            if (this.proxyUserPassword != null) {
                request.addHeader("Proxy-Authorization", "Basic " + this.proxyUserPassword);
            } else {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("proxy password is not send send error");
                }
                exchange.sendError(new IOException("proxy user password is not set (hint: usage <HttpClient>.setProxyPassword(...)"));
                return;
            }
        }
        HttpRequest wrappedRequest = null;
        wrappedRequest = request.hasBody() ? new HttpRequest((IHttpRequestHeader)new NonSSLRequestHeaderWrapper(request.getRequestHeader()), request.getNonBlockingBody()) : new HttpRequest(new NonSSLRequestHeaderWrapper(request.getRequestHeader()));
        exchange.forward(wrappedRequest);
    }

    private void forwardSSL(IHttpExchange exchange) throws IOException {
        String host;
        String forwardHost = host = exchange.getRequest().getHeader("Host");
        int forwardPort = 443;
        int idx = host.lastIndexOf(":");
        if (idx != -1) {
            forwardPort = Integer.parseInt(host.substring(idx + 1, host.length()));
            forwardHost = host.substring(0, idx);
        }
        NonBlockingConnection con = new NonBlockingConnection(this.securedProxyHost, this.securedProxyPort, this.sslContext, false);
        con.setHandler((IHandler)new DataHandler(exchange));
        StringBuilder sb = new StringBuilder();
        sb.append("CONNECT " + forwardHost + ":" + forwardPort + " HTTP/1.1\r\n" + "Host: " + host + "\r\n" + "User-Agent: xLightweb/" + HttpUtils.getImplementationVersion() + "\r\n");
        if (this.proxyUser != null) {
            if (this.proxyUserPassword != null) {
                sb.append("Proxy-Authorization: Basic " + this.proxyUserPassword + "\r\n");
            } else {
                exchange.sendError(401, "proxy user password is not set (hint: usage <HttpClient>.setProxyPassword(...)");
                return;
            }
        }
        sb.append("Proxy-Connection: keep-alive\r\n\r\n");
        con.write(sb.toString());
    }

    private final class NonSSLRequestHeaderWrapper
    extends HttpRequestHeaderWrapper {
        public NonSSLRequestHeaderWrapper(IHttpRequestHeader delegee) {
            super(delegee);
        }

        public URL getRequestUrl() {
            try {
                URL orgURL = this.getWrappedRequestHeader().getRequestUrl();
                int port = ProxyHandler.this.proxyPort;
                if (port == -1) {
                    port = 80;
                }
                URL url = new URL("http", ProxyHandler.this.proxyHost, port, orgURL.getFile());
                return url;
            }
            catch (MalformedURLException murl) {
                throw new RuntimeException(murl.toString());
            }
        }

        public String toString() {
            String s = this.getWrappedRequestHeader().toString();
            int idx = s.indexOf("\r\n");
            StringBuilder sb = new StringBuilder(this.getMethod() + " http://" + this.getHost() + this.getRequestURI());
            if (this.getQueryString() != null) {
                sb.append("?");
                sb.append(this.getQueryString());
            }
            sb.append(" ");
            sb.append(this.getProtocol());
            sb.append("\r\n");
            sb.append(s.substring(idx + 2, s.length()));
            return sb.toString();
        }
    }

    private static final class DataHandler
    implements IDataHandler {
        private IHttpExchange exchange = null;

        public DataHandler(IHttpExchange exchange) {
            this.exchange = exchange;
        }

        public boolean onData(INonBlockingConnection connection) throws IOException, BufferUnderflowException, ClosedChannelException, MaxReadSizeExceededException {
            int idx;
            String header = connection.readStringByDelimiter("\r\n\r\n");
            String[] lines = header.split("\r\n");
            String statusAndReason = lines[0].substring(idx = lines[0].indexOf(" "), lines[0].length()).trim();
            if (!statusAndReason.startsWith("200")) {
                this.exchange.sendError(new IOException("could not set up tunnel to " + this.exchange.getRequest().getHeader("Host") + " got " + statusAndReason));
                connection.close();
                return true;
            }
            IHttpResponseHandler respHdl = new IHttpResponseHandler(){

                public void onResponse(IHttpResponse response) throws IOException {
                    DataHandler.this.exchange.send(response);
                }

                public void onException(IOException ioe) throws IOException {
                    DataHandler.this.exchange.sendError(ioe);
                }
            };
            connection.activateSecuredMode();
            new HttpClientConnection(connection).send(this.exchange.getRequest(), respHdl);
            return true;
        }
    }
}

