/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.sdjwt;

import java.util.Objects;
import org.keycloak.jose.jws.crypto.HashUtils;
import org.keycloak.sdjwt.SdJwtSalt;
import org.keycloak.sdjwt.SdJwtUtils;

public abstract class DecoyEntry {
    private final SdJwtSalt salt;

    protected DecoyEntry(SdJwtSalt salt) {
        this.salt = Objects.requireNonNull(salt, "DecoyEntry always requires a non null salt");
    }

    public SdJwtSalt getSalt() {
        return this.salt;
    }

    public String getDisclosureDigest(String hashAlg) {
        return SdJwtUtils.encodeNoPad(HashUtils.hash(hashAlg, this.salt.toString().getBytes()));
    }
}

