/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.iconloader.util;

import com.bulenkov.iconloader.util.Base64Converter;
import com.bulenkov.iconloader.util.Pair;
import com.bulenkov.iconloader.util.StringUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class URLUtil {
    public static final String SCHEME_SEPARATOR = "://";
    public static final String FILE_PROTOCOL = "file";
    public static final String HTTP_PROTOCOL = "http";
    public static final String JAR_PROTOCOL = "jar";
    public static final String JAR_SEPARATOR = "!/";
    public static final Pattern DATA_URI_PATTERN = Pattern.compile("data:([^,;]+/[^,;]+)(;charset=[^,;]+)?(;base64)?,(.+)");

    private URLUtil() {
    }

    public static InputStream openStream(URL url) throws IOException {
        String protocol = url.getProtocol();
        return protocol.equals(JAR_PROTOCOL) ? URLUtil.openJarStream(url) : url.openStream();
    }

    public static InputStream openResourceStream(URL url) throws IOException {
        try {
            return URLUtil.openStream(url);
        }
        catch (FileNotFoundException ex) {
            InputStream resourceStream;
            int pos;
            String protocol = url.getProtocol();
            String file = null;
            if (protocol.equals(FILE_PROTOCOL)) {
                file = url.getFile();
            } else if (protocol.equals(JAR_PROTOCOL) && (pos = url.getFile().indexOf("!")) >= 0) {
                file = url.getFile().substring(pos + 1);
            }
            if (file != null && file.startsWith("/") && (resourceStream = URLUtil.class.getResourceAsStream(file)) != null) {
                return resourceStream;
            }
            throw ex;
        }
    }

    private static InputStream openJarStream(URL url) throws IOException {
        Pair<String, String> paths = URLUtil.splitJarUrl(url.getFile());
        if (paths == null) {
            throw new MalformedURLException(url.getFile());
        }
        final ZipFile zipFile = new ZipFile(URLUtil.unquote((String)paths.first));
        ZipEntry zipEntry = zipFile.getEntry((String)paths.second);
        if (zipEntry == null) {
            throw new FileNotFoundException("Entry " + (String)paths.second + " not found in " + (String)paths.first);
        }
        return new FilterInputStream(zipFile.getInputStream(zipEntry)){

            @Override
            public void close() throws IOException {
                super.close();
                zipFile.close();
            }
        };
    }

    public static String unquote(String urlString) {
        urlString = urlString.replace('/', File.separatorChar);
        return URLUtil.unescapePercentSequences(urlString);
    }

    public static Pair<String, String> splitJarUrl(String fullPath) {
        int delimiter = fullPath.indexOf(JAR_SEPARATOR);
        if (delimiter >= 0) {
            String resourcePath = fullPath.substring(delimiter + 2);
            String jarPath = fullPath.substring(0, delimiter);
            if (StringUtil.startsWithConcatenation(jarPath, FILE_PROTOCOL, ":")) {
                jarPath = jarPath.substring(FILE_PROTOCOL.length() + 1);
                return Pair.create(jarPath, resourcePath);
            }
        }
        return null;
    }

    public static String unescapePercentSequences(String s) {
        if (s.indexOf(37) == -1) {
            return s;
        }
        StringBuilder decoded = new StringBuilder();
        int len = s.length();
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if (c == '%') {
                ArrayList<Integer> bytes = new ArrayList<Integer>();
                while (i + 2 < len && s.charAt(i) == '%') {
                    int d1 = URLUtil.decode(s.charAt(i + 1));
                    int d2 = URLUtil.decode(s.charAt(i + 2));
                    if (d1 == -1 || d2 == -1) break;
                    bytes.add((d1 & 0xF) << 4 | d2 & 0xF);
                    i += 3;
                }
                if (!bytes.isEmpty()) {
                    byte[] bytesArray = new byte[bytes.size()];
                    for (int j = 0; j < bytes.size(); ++j) {
                        bytesArray[j] = ((Integer)bytes.get(j)).byteValue();
                    }
                    decoded.append(new String(bytesArray, Charset.forName("UTF-8")));
                    continue;
                }
            }
            decoded.append(c);
            ++i;
        }
        return decoded.toString();
    }

    private static int decode(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        return -1;
    }

    public static boolean containsScheme(String url) {
        return url.contains(SCHEME_SEPARATOR);
    }

    public static boolean isDataUri(String value) {
        return !value.isEmpty() && value.startsWith("data:", value.charAt(0) == '\"' || value.charAt(0) == '\'' ? 1 : 0);
    }

    public static byte[] getBytesFromDataUri(String dataUrl) {
        Matcher matcher = DATA_URI_PATTERN.matcher(StringUtil.stripQuotesAroundValue(dataUrl));
        if (matcher.matches()) {
            try {
                String content = matcher.group(4);
                Charset charset = Charset.forName("UTF-8");
                byte[] bytes = content.getBytes(charset);
                return ";base64".equalsIgnoreCase(matcher.group(3)) ? Base64Converter.decode(bytes) : bytes;
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        return null;
    }
}

