/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.view.startup;

import com.paterva.maltego.automation.view.startup.RunActions;
import com.paterva.maltego.util.ui.CheckListItem;
import com.paterva.maltego.util.ui.RadioButtonList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.util.NbBundle;

public class MachineSelectionControl
extends JPanel {
    private final RadioButtonList _list;
    private JCheckBox _showOnEmptyClickCheckBox;
    private JCheckBox _showOnStartCheckBox;
    private JPanel jPanel1;

    public MachineSelectionControl() {
        this.initComponents();
        this._list = new RadioButtonList();
        this.add((Component)this._list, "Center");
        this._list.setPreferredSize(new Dimension(220, 200));
        boolean enableAnnoyingActions = false;
        if (enableAnnoyingActions) {
            this._showOnStartCheckBox.setSelected(RunActions.isShowOnStartup());
            this._showOnStartCheckBox.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    RunActions.setShowOnStartup(MachineSelectionControl.this._showOnStartCheckBox.isSelected());
                }
            });
            this._showOnEmptyClickCheckBox.setSelected(RunActions.isShowOnEmptyGraphClick());
            this._showOnEmptyClickCheckBox.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    RunActions.setShowOnEmptyGraphClick(MachineSelectionControl.this._showOnEmptyClickCheckBox.isSelected());
                }
            });
        } else {
            this._showOnStartCheckBox.setVisible(false);
            this._showOnEmptyClickCheckBox.setVisible(false);
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this._showOnStartCheckBox = new JCheckBox();
        this._showOnEmptyClickCheckBox = new JCheckBox();
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        this.setLayout(new BorderLayout(0, 10));
        this.jPanel1.setLayout(new BorderLayout());
        this._showOnStartCheckBox.setText(NbBundle.getMessage(MachineSelectionControl.class, (String)"MachineSelectionControl._showOnStartCheckBox.text"));
        this.jPanel1.add((Component)this._showOnStartCheckBox, "North");
        this._showOnEmptyClickCheckBox.setText(NbBundle.getMessage(MachineSelectionControl.class, (String)"MachineSelectionControl._showOnEmptyClickCheckBox.text"));
        this.jPanel1.add((Component)this._showOnEmptyClickCheckBox, "Center");
        this.add((Component)this.jPanel1, "South");
    }

    public void addChangeListener(ChangeListener listener) {
        this._list.addChangeListener(listener);
    }

    public void setItems(CheckListItem[] items) {
        this._list.setListItems(items);
    }

    public CheckListItem getSelectedItem() {
        return this._list.getSelectedItem();
    }

    public void setSelectedItem(CheckListItem cli) {
        this._list.setSelectedItem(cli);
    }
}

