/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.convertor;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.project.ui.convertor.ProjectConvertorAcceptor;
import org.netbeans.modules.project.uiapi.ProjectConvertorServiceFactory;
import org.netbeans.modules.project.uiapi.ProjectOpenedTrampoline;
import org.netbeans.spi.project.ProjectFactory2;
import org.netbeans.spi.project.ProjectState;
import org.netbeans.spi.project.ui.ProjectConvertor;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.Parameters;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public final class ProjectConvertorFactory
implements ProjectFactory2 {
    private final Lookup.Result<ProjectConvertorAcceptor> acceptors = Lookup.getDefault().lookupResult(ProjectConvertorAcceptor.class);
    private final Lookup.Result<ProjectConvertorServiceFactory> services = Lookup.getDefault().lookupResult(ProjectConvertorServiceFactory.class);
    private final Set<FileObject> excluded = new HashSet<FileObject>();

    @CheckForNull
    public ProjectManager.Result isProject2(@NonNull FileObject projectDirectory) {
        Parameters.notNull((CharSequence)"projectDirectory", (Object)projectDirectory);
        ProjectConvertor.Result res = this.isProjectImpl(projectDirectory);
        return res != null ? this.toProjectManagerResult(res) : null;
    }

    public boolean isProject(@NonNull FileObject projectDirectory) {
        return this.isProject2(projectDirectory) != null;
    }

    @CheckForNull
    public Project loadProject(@NonNull FileObject projectDirectory, @NonNull ProjectState state) throws IOException {
        Parameters.notNull((CharSequence)"projectDirectory", (Object)projectDirectory);
        Parameters.notNull((CharSequence)"state", (Object)state);
        ProjectConvertor.Result res = this.isProjectImpl(projectDirectory);
        return res != null ? new ConvertorProject(projectDirectory, state, res) : null;
    }

    public void saveProject(@NonNull Project project) throws IOException, ClassCastException {
        Parameters.notNull((CharSequence)"project", (Object)project);
        throw new IllegalStateException("ConvertorProject cannot be modified");
    }

    public static boolean isConvertorProject(@NonNull Project project) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        return project.getLookup().lookup(ConvertorProject.class) != null;
    }

    public static void unregisterConvertorProject(@NonNull Project project) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        if (!ProjectManager.mutex().isWriteAccess()) {
            throw new IllegalStateException("Requires a write access on the ProjectManager's mutex");
        }
        ConvertorProject cp = (ConvertorProject)project.getLookup().lookup(ConvertorProject.class);
        if (cp == null) {
            throw new IllegalArgumentException(String.format("The project: %s located in: %s of type: %s is not a convertor project.", ProjectUtils.getInformation((Project)project).getDisplayName(), FileUtil.getFileDisplayName((FileObject)project.getProjectDirectory()), project.getClass().getName()));
        }
        cp.projectState.notifyDeleted();
    }

    @CheckForNull
    private ProjectConvertor.Result isProjectImpl(final @NonNull FileObject projectDirectory) {
        return (ProjectConvertor.Result)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<ProjectConvertor.Result>(){

            public ProjectConvertor.Result run() {
                if (!ProjectConvertorFactory.this.excluded.contains(projectDirectory)) {
                    for (ProjectConvertorAcceptor pc : ProjectConvertorFactory.this.acceptors.allInstances()) {
                        ProjectConvertor.Result result = pc.isProject(projectDirectory);
                        if (result == null) continue;
                        return result;
                    }
                }
                return null;
            }
        });
    }

    @NonNull
    private ProjectManager.Result toProjectManagerResult(@NonNull ProjectConvertor.Result res) {
        return new ProjectManager.Result(res.getDisplayName(), null, res.getIcon());
    }

    private static final class DynamicLookup
    extends ProxyLookup {
        DynamicLookup() {
        }

        DynamicLookup(Lookup ... lkps) {
            super(lkps);
        }

        void setBaseLookups(Lookup ... lkps) {
            Parameters.notNull((CharSequence)"lkps", (Object)lkps);
            this.setLookups(lkps);
        }

        @NonNull
        Lookup[] getBaseLookups() {
            return super.getLookups();
        }
    }

    private final class ConvertorProject
    implements Project {
        private final FileObject projectDirectory;
        private final ProjectState projectState;
        private final ProjectConvertor.Result result;
        private final ThreadLocal<DynamicLookup> underConstruction;
        private DynamicLookup projectLkp;

        ConvertorProject(@NonNull FileObject projectDirectory, @NonNull ProjectState projectState, ProjectConvertor.Result result) {
            Parameters.notNull((CharSequence)"projectDirectory", (Object)projectDirectory);
            Parameters.notNull((CharSequence)"projectState", (Object)projectState);
            Parameters.notNull((CharSequence)"result", (Object)result);
            this.projectDirectory = projectDirectory;
            this.projectState = projectState;
            this.result = result;
            this.underConstruction = new ThreadLocal();
        }

        @NonNull
        public FileObject getProjectDirectory() {
            return this.projectDirectory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NonNull
        public DynamicLookup getLookup() {
            DynamicLookup dynLkp = this.underConstruction.get();
            if (dynLkp != null) {
                return dynLkp;
            }
            ConvertorProject convertorProject = this;
            synchronized (convertorProject) {
                dynLkp = this.projectLkp;
            }
            if (dynLkp != null) {
                return dynLkp;
            }
            dynLkp = new DynamicLookup(Lookups.singleton((Object)this));
            try {
                this.underConstruction.set(dynLkp);
                Lookup preLkp = Lookups.fixed((Object[])new Object[]{new OpenHook(), this});
                Lookup convertorLkp = this.result.getLookup();
                if (convertorLkp == null) {
                    throw new IllegalStateException(String.format("Convertor: %s returned null lookup.", this.result));
                }
                ArrayDeque postServices = new ArrayDeque();
                for (ProjectConvertorServiceFactory f : ProjectConvertorFactory.this.services.allInstances()) {
                    postServices.addAll(f.createServices(this, this.result));
                }
                Lookup postLkp = Lookups.fixed((Object[])postServices.toArray());
                dynLkp.setBaseLookups(preLkp, convertorLkp, postLkp);
                Object object = this;
                synchronized (object) {
                    if (this.projectLkp == null) {
                        this.projectLkp = dynLkp;
                    } else {
                        dynLkp = this.projectLkp;
                    }
                }
                object = dynLkp;
                return object;
            }
            finally {
                this.underConstruction.remove();
            }
        }

        public int hashCode() {
            return this.projectDirectory.hashCode();
        }

        public boolean equals(@NullAllowed Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Project)) {
                return false;
            }
            return this.projectDirectory.equals(((Project)obj).getProjectDirectory());
        }

        @NonNull
        private Project createProject() throws IOException {
            try {
                return (Project)ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Project>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Project run() throws Exception {
                        ProjectConvertorFactory.this.excluded.add(ConvertorProject.this.projectDirectory);
                        try {
                            ConvertorProject.this.projectState.notifyDeleted();
                            Project prj = ConvertorProject.this.result.createProject();
                            if (prj == null) {
                                throw new IllegalStateException(String.format("The convertor %s created null project.", ConvertorProject.this.result));
                            }
                            DynamicLookup dynLkp = ConvertorProject.this.getLookup();
                            Lookup[] baseLkps = dynLkp.getBaseLookups();
                            dynLkp.setBaseLookups(baseLkps[1], prj.getLookup());
                            Project project = prj;
                            return project;
                        }
                        finally {
                            ProjectConvertorFactory.this.excluded.remove(ConvertorProject.this.projectDirectory);
                        }
                    }
                });
            }
            catch (MutexException e) {
                Exception root = e.getException();
                if (root instanceof RuntimeException) {
                    throw (RuntimeException)root;
                }
                if (root instanceof IOException) {
                    throw (IOException)root;
                }
                throw new RuntimeException(root);
            }
        }

        private final class OpenHook
        extends ProjectOpenedHook {
            private OpenHook() {
            }

            @Override
            protected void projectOpened() {
                try {
                    Project prj = ConvertorProject.this.createProject();
                    for (ProjectOpenedHook hook : prj.getLookup().lookupAll(ProjectOpenedHook.class)) {
                        ProjectOpenedTrampoline.DEFAULT.projectOpened(hook);
                    }
                }
                catch (IOException ioe) {
                    Exceptions.printStackTrace((Throwable)ioe);
                }
            }

            @Override
            protected void projectClosed() {
            }
        }
    }
}

