/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.propertygrid.editors;

import com.paterva.maltego.typing.DataSource;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.EditorDescriptor;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.editing.UnsupportedEditorException;
import com.paterva.maltego.typing.editing.propertygrid.DisplayDescriptorProperty;
import com.paterva.maltego.typing.editing.propertygrid.PropertyDescriptorProperty;
import com.paterva.maltego.typing.editing.propertygrid.editors.AttachmentsPropertyEditor;
import com.paterva.maltego.typing.editing.propertygrid.editors.BinaryFileProperty;
import com.paterva.maltego.typing.editing.propertygrid.editors.ComboBoxProperty;
import com.paterva.maltego.typing.editing.propertygrid.editors.DefaultPropertyEditorFactory;
import com.paterva.maltego.typing.editing.propertygrid.editors.ImageFileProperty;
import com.paterva.maltego.typing.editing.propertygrid.editors.PropertyFactory;
import com.paterva.maltego.typing.editors.BooleanFormat;
import com.paterva.maltego.typing.editors.FileBrowserEditorDescriptor;
import com.paterva.maltego.typing.editors.OptionEditorDescriptor;
import com.paterva.maltego.typing.types.Attachments;
import com.paterva.maltego.typing.types.BinaryFile;
import com.paterva.maltego.typing.types.DateRange;
import com.paterva.maltego.typing.types.IPAddress;
import com.paterva.maltego.typing.types.PhoneNumber;
import com.paterva.maltego.util.FileExtensionFileFilter;
import java.awt.Image;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.openide.nodes.Node;

public class DefaultPropertyFactory
extends PropertyFactory {
    private final DefaultPropertyEditorFactory _editorFactory = new DefaultPropertyEditorFactory();

    protected DefaultPropertyFactory() {
    }

    @Override
    public Node.Property createProperty(DisplayDescriptor descriptor, DataSource data) throws UnsupportedEditorException {
        Node.Property property;
        if (Boolean.TYPE.isAssignableFrom(descriptor.getType())) {
            property = this.createBooleanProperty(descriptor, data);
        } else if (Image.class.isAssignableFrom(descriptor.getType())) {
            property = new ImageFileProperty(descriptor, data);
        } else if (BinaryFile.class.isAssignableFrom(descriptor.getType())) {
            property = new BinaryFileProperty(descriptor, data);
            this.updateFileBrowser(property, descriptor.getEditor());
        } else if (File.class.isAssignableFrom(descriptor.getType())) {
            property = new DisplayDescriptorProperty(descriptor, data);
            this.updateFileBrowser(property, descriptor.getEditor());
        } else if (IPAddress.class.isAssignableFrom(descriptor.getType())) {
            property = new PropertyDescriptorProperty(String.class, (PropertyDescriptor)descriptor, data);
        } else if (PhoneNumber.class.isAssignableFrom(descriptor.getType())) {
            property = new PropertyDescriptorProperty(String.class, (PropertyDescriptor)descriptor, data);
        } else if (Attachments.class.isAssignableFrom(descriptor.getType())) {
            DisplayDescriptorProperty ddp = new DisplayDescriptorProperty(descriptor, data);
            ddp.setPropertyEditor(new AttachmentsPropertyEditor(data));
            ddp.setValue("canEditAsText", Boolean.FALSE);
            property = ddp;
        } else if (descriptor.getEditor() instanceof OptionEditorDescriptor) {
            property = new ComboBoxProperty(descriptor, data);
        } else {
            final boolean isDateRange = DateRange.class.isAssignableFrom(descriptor.getType());
            DisplayDescriptorProperty ddp = new DisplayDescriptorProperty(descriptor, data){

                @Override
                public boolean isDefaultValue() {
                    boolean defaultValue = super.isDefaultValue();
                    if (isDateRange) {
                        defaultValue = true;
                    }
                    return defaultValue;
                }
            };
            ddp.setPropertyEditor(this._editorFactory.createEditor(descriptor, data));
            if (isDateRange) {
                ddp.setValue("canEditAsText", Boolean.FALSE);
            }
            property = ddp;
        }
        return property;
    }

    private Node.Property createBooleanProperty(DisplayDescriptor descriptor, DataSource data) {
        DisplayDescriptorProperty property = new DisplayDescriptorProperty(descriptor, data);
        if (descriptor.getFormat() != null) {
            BooleanFormat format = (BooleanFormat)descriptor.getFormat();
            property.setValue("stringValues", new String[]{format.getTrueValue(), format.getFalseValue()});
            try {
                property.setValue(false);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        return property;
    }

    private void updateFileBrowser(Node.Property property, EditorDescriptor editor) {
        if (editor instanceof FileBrowserEditorDescriptor) {
            FileBrowserEditorDescriptor browser = (FileBrowserEditorDescriptor)editor;
            property.setValue("directories", (Object)browser.isSelectDirectories());
            property.setValue("files", (Object)browser.isSelectFiles());
            if (browser.getExtensions() != null && browser.getExtensions().length > 0) {
                property.setValue("filter", (Object)new FileExtensionFileFilter(browser.getExtensions(), browser.getFilterTitle()));
            }
        }
    }
}

