/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.treelist.parts;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.graph.GraphLifeCycleManager;
import com.paterva.maltego.graph.cache.PartCache;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphDataStoreReader;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.data.sort.PartSortAndFilterInfo;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.graph.store.view.GraphModelViewMappings;
import com.paterva.maltego.graph.store.view.GraphStoreView;
import com.paterva.maltego.graph.store.view.GraphStoreViewRegistry;
import com.paterva.maltego.treelist.lazy.outline.SortPermutations;
import com.paterva.maltego.treelist.parts.PartLoadedCallback;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

public abstract class CachedLazyPartsProvider<PartID extends Guid, Part extends MaltegoPart<PartID>> {
    private static final Logger LOG = Logger.getLogger(CachedLazyPartsProvider.class.getName());
    protected static final int CACHE_SIZE = 500;
    private GraphID _graphID;
    private Set<PartID> _activeModelPartIDSet = Collections.EMPTY_SET;
    private List<PartID> _activeModelPartIDs = Collections.EMPTY_LIST;
    private List<PartID> _sortedModelPartIDs = Collections.EMPTY_LIST;
    private PartSortAndFilterInfo _sortOrder = PartSortAndFilterInfo.DEFAULT;
    private GraphLifeCycleListener _graphLifeCycleListener;

    public abstract PartCache<PartID, Part> getCache();

    public abstract Map<PartID, Part> getParts(Collection<PartID> var1);

    public abstract List<PartID> getSortedFilteredIDs(Collection<PartID> var1, PartSortAndFilterInfo var2);

    public GraphID getGraphID() {
        return this._graphID;
    }

    public void setGraphID(GraphID graphID) {
        if (!Utilities.compareObjects((Object)this._graphID, (Object)graphID)) {
            if (this._graphID != null) {
                this.removeListeners();
            }
            this._graphID = graphID;
            LOG.log(Level.FINE, "Graph: {0}", this._graphID);
            this.clearCache();
            if (this._graphID != null) {
                this.addListeners();
            }
        }
    }

    public List<PartID> getActiveModelPartIDs() {
        return this._activeModelPartIDs;
    }

    public Set<PartID> getActiveModelPartIDSet() {
        return this._activeModelPartIDSet;
    }

    public void setActiveModelPartIDs(Set<PartID> activeModelPartIDs) {
        this._activeModelPartIDSet = new HashSet<PartID>(activeModelPartIDs);
        List<PartID> sortedIDs = this.getSortedFilteredIDs(this._activeModelPartIDSet, PartSortAndFilterInfo.DEFAULT);
        this._activeModelPartIDs = Collections.unmodifiableList(sortedIDs);
        this._sortedModelPartIDs = PartSortAndFilterInfo.DEFAULT.equals((Object)this._sortOrder) ? sortedIDs : this.getSortedFilteredIDs(this._activeModelPartIDs, this._sortOrder);
        LOG.log(Level.FINE, "Active IDs: {0}", this._activeModelPartIDs);
        LOG.log(Level.FINE, "Sorted Filtered IDs: {0}", this._sortedModelPartIDs);
    }

    public SortPermutations getSortPermutations(PartSortAndFilterInfo partSortOrder) {
        if (!Utilities.compareObjects((Object)this._sortOrder, (Object)partSortOrder)) {
            this._sortOrder = partSortOrder;
            this._sortedModelPartIDs = this.getSortedFilteredIDs(this._activeModelPartIDs, this._sortOrder);
            LOG.log(Level.FINE, "Sorted Filtered IDs: {0}", this._sortedModelPartIDs);
        }
        ArrayList<PartID> modelIDList = new ArrayList<PartID>(this._activeModelPartIDs);
        int[] sortingPermutation = new int[this._sortedModelPartIDs.size()];
        int[] inverseSortingPermutation = new int[this._activeModelPartIDs.size()];
        int sortedIndex = 0;
        for (Guid id : this._sortedModelPartIDs) {
            int originalIndex;
            sortingPermutation[sortedIndex] = originalIndex = modelIDList.indexOf(id);
            inverseSortingPermutation[originalIndex] = sortedIndex++;
        }
        return new SortPermutations(sortingPermutation, inverseSortingPermutation);
    }

    public List<PartID> getSortedModelPartIDs() {
        return this._sortedModelPartIDs;
    }

    public Optional<Part> getPart(PartID modelPartID, PartLoadedCallback<Part> cb) {
        PartCache<PartID, Part> cache = this.getCache();
        MaltegoPart part = (MaltegoPart)cache.get(modelPartID);
        if (part == null) {
            List<PartID> sortedModelPartIDs = this.getSortedModelPartIDs();
            int index = sortedModelPartIDs.indexOf(modelPartID);
            int low = Math.max(0, index - 125);
            int high = Math.min(sortedModelPartIDs.size() - 1, index + 125);
            List<PartID> subListIDs = sortedModelPartIDs.subList(low, high + 1);
            HashSet<Guid> idsToQuery = new HashSet<Guid>();
            for (Guid subListID : subListIDs) {
                if (cache.get((Object)subListID) != null) continue;
                idsToQuery.add(subListID);
            }
            Map parts = this.getParts(idsToQuery);
            cache.put(parts.values());
            part = (MaltegoPart)parts.get(modelPartID);
        }
        return Optional.ofNullable(part);
    }

    protected void addListeners() {
        this._graphLifeCycleListener = new GraphLifeCycleListener();
        GraphLifeCycleManager.getDefault().addPropertyChangeListener((PropertyChangeListener)this._graphLifeCycleListener);
    }

    protected void removeListeners() {
        if (this._graphLifeCycleListener != null) {
            GraphLifeCycleManager.getDefault().removePropertyChangeListener((PropertyChangeListener)this._graphLifeCycleListener);
            this._graphLifeCycleListener = null;
        }
    }

    private void clearCache() {
        this.getCache().clear();
    }

    protected GraphStoreView getGraphStoreView() {
        return this._graphID == null ? null : GraphStoreViewRegistry.getDefault().getDefaultView(this._graphID);
    }

    protected GraphModelViewMappings getModelViewMappings() {
        GraphStoreView view = this.getGraphStoreView();
        return view == null ? null : view.getModelViewMappings();
    }

    protected GraphStore getGraphStore() {
        try {
            return this._graphID == null ? null : GraphStoreRegistry.getDefault().forGraphID(this._graphID);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    protected GraphDataStoreReader getDataReader() {
        GraphStore graphStore = this.getGraphStore();
        return graphStore == null ? null : graphStore.getGraphDataStore().getDataStoreReader();
    }

    protected GraphStructureReader getStructureReader() {
        GraphStore graphStore = this.getGraphStore();
        return graphStore == null ? null : graphStore.getGraphStructureStore().getStructureReader();
    }

    private class GraphLifeCycleListener
    implements PropertyChangeListener {
        private GraphLifeCycleListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("graphClosing".equals(evt.getPropertyName()) && evt.getNewValue().equals(CachedLazyPartsProvider.this._graphID)) {
                CachedLazyPartsProvider.this.removeListeners();
                CachedLazyPartsProvider.this._graphID = null;
                CachedLazyPartsProvider.this._activeModelPartIDs = null;
                CachedLazyPartsProvider.this._activeModelPartIDSet = null;
                CachedLazyPartsProvider.this._sortedModelPartIDs = null;
                CachedLazyPartsProvider.this.clearCache();
            }
        }
    }
}

