// Code generated by go generate; DO NOT EDIT.
package jira

import "errors"

type Permission int

const (
    Invalid Permission = iota
    AddComments Permission = iota
    Administer Permission = iota
    AdministerProjects Permission = iota
    AssignableUser Permission = iota
    AssignIssues Permission = iota
    BrowseProjects Permission = iota
    BulkChange Permission = iota
    CloseIssues Permission = iota
    CreateAttachments Permission = iota
    CreateIssues Permission = iota
    CreateProject Permission = iota
    CreateSharedObjects Permission = iota
    DeleteAllAttachments Permission = iota
    DeleteAllComments Permission = iota
    DeleteAllWorklogs Permission = iota
    DeleteIssues Permission = iota
    DeleteOwnAttachments Permission = iota
    DeleteOwnComments Permission = iota
    DeleteOwnWorklogs Permission = iota
    EditAllComments Permission = iota
    EditAllWorklogs Permission = iota
    EditIssues Permission = iota
    EditIssueLayout Permission = iota
    EditOwnComments Permission = iota
    EditOwnWorklogs Permission = iota
    EditWorkflow Permission = iota
    LinkIssues Permission = iota
    ManageGroupFilterSubscriptions Permission = iota
    ManageSprintsPermission Permission = iota
    ManageWatchers Permission = iota
    ModifyReporter Permission = iota
    MoveIssues Permission = iota
    ResolveIssues Permission = iota
    ScheduleIssues Permission = iota
    SetIssueSecurity Permission = iota
    SystemAdmin Permission = iota
    TransitionIssues Permission = iota
    UnarchiveIssues Permission = iota
    UserPicker Permission = iota
    ViewAggregatedData Permission = iota
    ViewDevTools Permission = iota
    ViewReadonlyWorkflow Permission = iota
    ViewVotersAndWatchers Permission = iota
    WorkOnIssues Permission = iota
)

var (
    PermissionStrings = map[Permission]string{
        AddComments: "add_comments",
        Administer: "administer",
        AdministerProjects: "administer_projects",
        AssignableUser: "assignable_user",
        AssignIssues: "assign_issues",
        BrowseProjects: "browse_projects",
        BulkChange: "bulk_change",
        CloseIssues: "close_issues",
        CreateAttachments: "create_attachments",
        CreateIssues: "create_issues",
        CreateProject: "create_project",
        CreateSharedObjects: "create_shared_objects",
        DeleteAllAttachments: "delete_all_attachments",
        DeleteAllComments: "delete_all_comments",
        DeleteAllWorklogs: "delete_all_worklogs",
        DeleteIssues: "delete_issues",
        DeleteOwnAttachments: "delete_own_attachments",
        DeleteOwnComments: "delete_own_comments",
        DeleteOwnWorklogs: "delete_own_worklogs",
        EditAllComments: "edit_all_comments",
        EditAllWorklogs: "edit_all_worklogs",
        EditIssues: "edit_issues",
        EditIssueLayout: "edit_issue_layout",
        EditOwnComments: "edit_own_comments",
        EditOwnWorklogs: "edit_own_worklogs",
        EditWorkflow: "edit_workflow",
        LinkIssues: "link_issues",
        ManageGroupFilterSubscriptions: "manage_group_filter_subscriptions",
        ManageSprintsPermission: "manage_sprints_permission",
        ManageWatchers: "manage_watchers",
        ModifyReporter: "modify_reporter",
        MoveIssues: "move_issues",
        ResolveIssues: "resolve_issues",
        ScheduleIssues: "schedule_issues",
        SetIssueSecurity: "set_issue_security",
        SystemAdmin: "system_admin",
        TransitionIssues: "transition_issues",
        UnarchiveIssues: "unarchive_issues",
        UserPicker: "user_picker",
        ViewAggregatedData: "view_aggregated_data",
        ViewDevTools: "view_dev_tools",
        ViewReadonlyWorkflow: "view_readonly_workflow",
        ViewVotersAndWatchers: "view_voters_and_watchers",
        WorkOnIssues: "work_on_issues",
    }

    StringToPermission = map[string]Permission{
        "add_comments": AddComments,
        "administer": Administer,
        "administer_projects": AdministerProjects,
        "assignable_user": AssignableUser,
        "assign_issues": AssignIssues,
        "browse_projects": BrowseProjects,
        "bulk_change": BulkChange,
        "close_issues": CloseIssues,
        "create_attachments": CreateAttachments,
        "create_issues": CreateIssues,
        "create_project": CreateProject,
        "create_shared_objects": CreateSharedObjects,
        "delete_all_attachments": DeleteAllAttachments,
        "delete_all_comments": DeleteAllComments,
        "delete_all_worklogs": DeleteAllWorklogs,
        "delete_issues": DeleteIssues,
        "delete_own_attachments": DeleteOwnAttachments,
        "delete_own_comments": DeleteOwnComments,
        "delete_own_worklogs": DeleteOwnWorklogs,
        "edit_all_comments": EditAllComments,
        "edit_all_worklogs": EditAllWorklogs,
        "edit_issues": EditIssues,
        "edit_issue_layout": EditIssueLayout,
        "edit_own_comments": EditOwnComments,
        "edit_own_worklogs": EditOwnWorklogs,
        "edit_workflow": EditWorkflow,
        "link_issues": LinkIssues,
        "manage_group_filter_subscriptions": ManageGroupFilterSubscriptions,
        "manage_sprints_permission": ManageSprintsPermission,
        "manage_watchers": ManageWatchers,
        "modify_reporter": ModifyReporter,
        "move_issues": MoveIssues,
        "resolve_issues": ResolveIssues,
        "schedule_issues": ScheduleIssues,
        "set_issue_security": SetIssueSecurity,
        "system_admin": SystemAdmin,
        "transition_issues": TransitionIssues,
        "unarchive_issues": UnarchiveIssues,
        "user_picker": UserPicker,
        "view_aggregated_data": ViewAggregatedData,
        "view_dev_tools": ViewDevTools,
        "view_readonly_workflow": ViewReadonlyWorkflow,
        "view_voters_and_watchers": ViewVotersAndWatchers,
        "work_on_issues": WorkOnIssues,
    }

    PermissionIDs = map[Permission]int{
        AddComments: 1,
        Administer: 2,
        AdministerProjects: 3,
        AssignableUser: 4,
        AssignIssues: 5,
        BrowseProjects: 6,
        BulkChange: 7,
        CloseIssues: 8,
        CreateAttachments: 9,
        CreateIssues: 10,
        CreateProject: 11,
        CreateSharedObjects: 12,
        DeleteAllAttachments: 13,
        DeleteAllComments: 14,
        DeleteAllWorklogs: 15,
        DeleteIssues: 16,
        DeleteOwnAttachments: 17,
        DeleteOwnComments: 18,
        DeleteOwnWorklogs: 19,
        EditAllComments: 20,
        EditAllWorklogs: 21,
        EditIssues: 22,
        EditIssueLayout: 23,
        EditOwnComments: 24,
        EditOwnWorklogs: 25,
        EditWorkflow: 26,
        LinkIssues: 27,
        ManageGroupFilterSubscriptions: 28,
        ManageSprintsPermission: 29,
        ManageWatchers: 30,
        ModifyReporter: 31,
        MoveIssues: 32,
        ResolveIssues: 33,
        ScheduleIssues: 34,
        SetIssueSecurity: 35,
        SystemAdmin: 36,
        TransitionIssues: 37,
        UnarchiveIssues: 38,
        UserPicker: 39,
        ViewAggregatedData: 40,
        ViewDevTools: 41,
        ViewReadonlyWorkflow: 42,
        ViewVotersAndWatchers: 43,
        WorkOnIssues: 44,
    }

    IdToPermission = map[int]Permission{
        1: AddComments,
        2: Administer,
        3: AdministerProjects,
        4: AssignableUser,
        5: AssignIssues,
        6: BrowseProjects,
        7: BulkChange,
        8: CloseIssues,
        9: CreateAttachments,
        10: CreateIssues,
        11: CreateProject,
        12: CreateSharedObjects,
        13: DeleteAllAttachments,
        14: DeleteAllComments,
        15: DeleteAllWorklogs,
        16: DeleteIssues,
        17: DeleteOwnAttachments,
        18: DeleteOwnComments,
        19: DeleteOwnWorklogs,
        20: EditAllComments,
        21: EditAllWorklogs,
        22: EditIssues,
        23: EditIssueLayout,
        24: EditOwnComments,
        25: EditOwnWorklogs,
        26: EditWorkflow,
        27: LinkIssues,
        28: ManageGroupFilterSubscriptions,
        29: ManageSprintsPermission,
        30: ManageWatchers,
        31: ModifyReporter,
        32: MoveIssues,
        33: ResolveIssues,
        34: ScheduleIssues,
        35: SetIssueSecurity,
        36: SystemAdmin,
        37: TransitionIssues,
        38: UnarchiveIssues,
        39: UserPicker,
        40: ViewAggregatedData,
        41: ViewDevTools,
        42: ViewReadonlyWorkflow,
        43: ViewVotersAndWatchers,
        44: WorkOnIssues,
    }
)

// ToString converts a Permission enum to its string representation
func (p Permission) ToString() (string, error) {
    if str, ok := PermissionStrings[p]; ok {
        return str, nil
    }
    return "", errors.New("invalid permission")
}

// ToID converts a Permission enum to its ID
func (p Permission) ToID() (int, error) {
    if id, ok := PermissionIDs[p]; ok {
        return id, nil
    }
    return 0, errors.New("invalid permission")
}

// PermissionFromString converts a string representation to its Permission enum
func PermissionFromString(s string) (Permission, error) {
    if p, ok := StringToPermission[s]; ok {
        return p, nil
    }
    return 0, errors.New("invalid permission string")
}

// PermissionFromID converts an ID to its Permission enum
func PermissionFromID(id int) (Permission, error) {
    if p, ok := IdToPermission[id]; ok {
        return p, nil
    }
    return 0, errors.New("invalid permission ID")
}
