// Code generated by go generate; DO NOT EDIT.
package classic

import "errors"

type Permission int

const (
    Invalid Permission = iota
    Repo Permission = iota
    RepoStatus Permission = iota
    RepoDeployment Permission = iota
    PublicRepo Permission = iota
    RepoInvite Permission = iota
    SecurityEvents Permission = iota
    Workflow Permission = iota
    WritePackages Permission = iota
    ReadPackages Permission = iota
    DeletePackages Permission = iota
    AdminOrg Permission = iota
    WriteOrg Permission = iota
    ReadOrg Permission = iota
    ManageRunnersOrg Permission = iota
    AdminPublicKey Permission = iota
    WritePublicKey Permission = iota
    ReadPublicKey Permission = iota
    AdminRepoHook Permission = iota
    WriteRepoHook Permission = iota
    ReadRepoHook Permission = iota
    AdminOrgHook Permission = iota
    Gist Permission = iota
    Notifications Permission = iota
    User Permission = iota
    ReadUser Permission = iota
    UserEmail Permission = iota
    UserFollow Permission = iota
    DeleteRepo Permission = iota
    WriteDiscussion Permission = iota
    ReadDiscussion Permission = iota
    AdminEnterprise Permission = iota
    ManageRunnersEnterprise Permission = iota
    ManageBillingEnterprise Permission = iota
    ReadEnterprise Permission = iota
    AuditLog Permission = iota
    ReadAuditLog Permission = iota
    Codespace Permission = iota
    CodespaceSecrets Permission = iota
    Copilot Permission = iota
    ManageBillingCopilot Permission = iota
    Project Permission = iota
    ReadProject Permission = iota
    AdminGpgKey Permission = iota
    WriteGpgKey Permission = iota
    ReadGpgKey Permission = iota
    AdminSshSigningKey Permission = iota
    WriteSshSigningKey Permission = iota
    ReadSshSigningKey Permission = iota
)

var (
    PermissionStrings = map[Permission]string{
        Repo: "repo",
        RepoStatus: "repo:status",
        RepoDeployment: "repo_deployment",
        PublicRepo: "public_repo",
        RepoInvite: "repo:invite",
        SecurityEvents: "security_events",
        Workflow: "workflow",
        WritePackages: "write:packages",
        ReadPackages: "read:packages",
        DeletePackages: "delete:packages",
        AdminOrg: "admin:org",
        WriteOrg: "write:org",
        ReadOrg: "read:org",
        ManageRunnersOrg: "manage_runners:org",
        AdminPublicKey: "admin:public_key",
        WritePublicKey: "write:public_key",
        ReadPublicKey: "read:public_key",
        AdminRepoHook: "admin:repo_hook",
        WriteRepoHook: "write:repo_hook",
        ReadRepoHook: "read:repo_hook",
        AdminOrgHook: "admin:org_hook",
        Gist: "gist",
        Notifications: "notifications",
        User: "user",
        ReadUser: "read:user",
        UserEmail: "user:email",
        UserFollow: "user:follow",
        DeleteRepo: "delete_repo",
        WriteDiscussion: "write:discussion",
        ReadDiscussion: "read:discussion",
        AdminEnterprise: "admin:enterprise",
        ManageRunnersEnterprise: "manage_runners:enterprise",
        ManageBillingEnterprise: "manage_billing:enterprise",
        ReadEnterprise: "read:enterprise",
        AuditLog: "audit_log",
        ReadAuditLog: "read:audit_log",
        Codespace: "codespace",
        CodespaceSecrets: "codespace:secrets",
        Copilot: "copilot",
        ManageBillingCopilot: "manage_billing:copilot",
        Project: "project",
        ReadProject: "read:project",
        AdminGpgKey: "admin:gpg_key",
        WriteGpgKey: "write:gpg_key",
        ReadGpgKey: "read:gpg_key",
        AdminSshSigningKey: "admin:ssh_signing_key",
        WriteSshSigningKey: "write:ssh_signing_key",
        ReadSshSigningKey: "read:ssh_signing_key",
    }

    StringToPermission = map[string]Permission{
        "repo": Repo,
        "repo:status": RepoStatus,
        "repo_deployment": RepoDeployment,
        "public_repo": PublicRepo,
        "repo:invite": RepoInvite,
        "security_events": SecurityEvents,
        "workflow": Workflow,
        "write:packages": WritePackages,
        "read:packages": ReadPackages,
        "delete:packages": DeletePackages,
        "admin:org": AdminOrg,
        "write:org": WriteOrg,
        "read:org": ReadOrg,
        "manage_runners:org": ManageRunnersOrg,
        "admin:public_key": AdminPublicKey,
        "write:public_key": WritePublicKey,
        "read:public_key": ReadPublicKey,
        "admin:repo_hook": AdminRepoHook,
        "write:repo_hook": WriteRepoHook,
        "read:repo_hook": ReadRepoHook,
        "admin:org_hook": AdminOrgHook,
        "gist": Gist,
        "notifications": Notifications,
        "user": User,
        "read:user": ReadUser,
        "user:email": UserEmail,
        "user:follow": UserFollow,
        "delete_repo": DeleteRepo,
        "write:discussion": WriteDiscussion,
        "read:discussion": ReadDiscussion,
        "admin:enterprise": AdminEnterprise,
        "manage_runners:enterprise": ManageRunnersEnterprise,
        "manage_billing:enterprise": ManageBillingEnterprise,
        "read:enterprise": ReadEnterprise,
        "audit_log": AuditLog,
        "read:audit_log": ReadAuditLog,
        "codespace": Codespace,
        "codespace:secrets": CodespaceSecrets,
        "copilot": Copilot,
        "manage_billing:copilot": ManageBillingCopilot,
        "project": Project,
        "read:project": ReadProject,
        "admin:gpg_key": AdminGpgKey,
        "write:gpg_key": WriteGpgKey,
        "read:gpg_key": ReadGpgKey,
        "admin:ssh_signing_key": AdminSshSigningKey,
        "write:ssh_signing_key": WriteSshSigningKey,
        "read:ssh_signing_key": ReadSshSigningKey,
    }

    PermissionIDs = map[Permission]int{
        Repo: 1,
        RepoStatus: 2,
        RepoDeployment: 3,
        PublicRepo: 4,
        RepoInvite: 5,
        SecurityEvents: 6,
        Workflow: 7,
        WritePackages: 8,
        ReadPackages: 9,
        DeletePackages: 10,
        AdminOrg: 11,
        WriteOrg: 12,
        ReadOrg: 13,
        ManageRunnersOrg: 14,
        AdminPublicKey: 15,
        WritePublicKey: 16,
        ReadPublicKey: 17,
        AdminRepoHook: 18,
        WriteRepoHook: 19,
        ReadRepoHook: 20,
        AdminOrgHook: 21,
        Gist: 22,
        Notifications: 23,
        User: 24,
        ReadUser: 25,
        UserEmail: 26,
        UserFollow: 27,
        DeleteRepo: 28,
        WriteDiscussion: 29,
        ReadDiscussion: 30,
        AdminEnterprise: 31,
        ManageRunnersEnterprise: 32,
        ManageBillingEnterprise: 33,
        ReadEnterprise: 34,
        AuditLog: 35,
        ReadAuditLog: 36,
        Codespace: 37,
        CodespaceSecrets: 38,
        Copilot: 39,
        ManageBillingCopilot: 40,
        Project: 41,
        ReadProject: 42,
        AdminGpgKey: 43,
        WriteGpgKey: 44,
        ReadGpgKey: 45,
        AdminSshSigningKey: 46,
        WriteSshSigningKey: 47,
        ReadSshSigningKey: 48,
    }

    IdToPermission = map[int]Permission{
        1: Repo,
        2: RepoStatus,
        3: RepoDeployment,
        4: PublicRepo,
        5: RepoInvite,
        6: SecurityEvents,
        7: Workflow,
        8: WritePackages,
        9: ReadPackages,
        10: DeletePackages,
        11: AdminOrg,
        12: WriteOrg,
        13: ReadOrg,
        14: ManageRunnersOrg,
        15: AdminPublicKey,
        16: WritePublicKey,
        17: ReadPublicKey,
        18: AdminRepoHook,
        19: WriteRepoHook,
        20: ReadRepoHook,
        21: AdminOrgHook,
        22: Gist,
        23: Notifications,
        24: User,
        25: ReadUser,
        26: UserEmail,
        27: UserFollow,
        28: DeleteRepo,
        29: WriteDiscussion,
        30: ReadDiscussion,
        31: AdminEnterprise,
        32: ManageRunnersEnterprise,
        33: ManageBillingEnterprise,
        34: ReadEnterprise,
        35: AuditLog,
        36: ReadAuditLog,
        37: Codespace,
        38: CodespaceSecrets,
        39: Copilot,
        40: ManageBillingCopilot,
        41: Project,
        42: ReadProject,
        43: AdminGpgKey,
        44: WriteGpgKey,
        45: ReadGpgKey,
        46: AdminSshSigningKey,
        47: WriteSshSigningKey,
        48: ReadSshSigningKey,
    }
)

// ToString converts a Permission enum to its string representation
func (p Permission) ToString() (string, error) {
    if str, ok := PermissionStrings[p]; ok {
        return str, nil
    }
    return "", errors.New("invalid permission")
}

// ToID converts a Permission enum to its ID
func (p Permission) ToID() (int, error) {
    if id, ok := PermissionIDs[p]; ok {
        return id, nil
    }
    return 0, errors.New("invalid permission")
}

// PermissionFromString converts a string representation to its Permission enum
func PermissionFromString(s string) (Permission, error) {
    if p, ok := StringToPermission[s]; ok {
        return p, nil
    }
    return 0, errors.New("invalid permission string")
}

// PermissionFromID converts an ID to its Permission enum
func PermissionFromID(id int) (Permission, error) {
    if p, ok := IdToPermission[id]; ok {
        return p, nil
    }
    return 0, errors.New("invalid permission ID")
}
