# Server plugin: UpstreamAuthority "disk"

The `disk` plugin loads CA credentials from disk, using them to generate
intermediate signing certificates for the server's signing authority. The
intermediate certificates are minted against CSRs generated by the ServerCA
plugin.

The `disk` plugin reloads CA credentials on all CSR requests. If the
credentials cannot be loaded, then the previously loaded credentials will be
used.  This provides two things: first, it ensures that the spire-server
process does not need to be restarted to load a new UpstreamAuthority from
disk, providing a seamless rotation; second, it ensures that a failed disk does
not affect a running spire-server until the loaded UpstreamAuthority expires.

The plugin accepts the following configuration options:

| Configuration    | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                |
|------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| cert_file_path   | If SPIRE is using a self-signed CA, `cert_file_path` should specify the path to a single PEM encoded certificate representing the upstream CA certificate. If not self-signed, `cert_file_path` should specify the path to a file that must contain one or more certificates necessary to establish a valid certificate chain up the root certificates defined in `bundle_file_path`.                                                                      |
| key_file_path    | Path to the "upstream" CA key file. Key files must contain a single PEM encoded key. The supported key types are EC (ASN.1 or PKCS8 encoded) or RSA (PKCS1 or PKCS8 encoded).                                                                                                                                                                                                                                                                              |
| bundle_file_path | If SPIRE is using a self-signed CA, `bundle_file_path` can be left unset. If not self-signed, then `bundle_file_path` should be the path to a file that must contain one or more certificates representing the upstream root certificates and the file at cert_file_path contains one or more certificates necessary to chain up the root certificates in bundle_file_path (where the first certificate in cert_file_path is the upstream CA certificate). |

The `disk` plugin is able to function as either a root CA, or join an existing PKI.

When joining an existing PKI, the trust bundle for that PKI MUST be set explicitly
using the `bundle_file_path` option; this MUST contain the certificates of the trusted
roots for the PKI being joined in PEM format. When using the `bundle_file_path` option
`cert_file_path` MUST contain a chain of certificates, in PEM format, up to the trusted
root.

When functioning as a root CA, the trust bundle is unused. The `cert_file_path` MUST contain
exactly one certificate which is self-signed and `key_file_path` MUST contain the key for
that certificate.

Key files must contain a single PEM encoded key. The supported key types are EC (ASN.1 or PKCS8 encoded) or RSA (PKCS1 or PKCS8 encoded).

A sample configuration:

```hcl
    UpstreamAuthority "disk" {
        plugin_data {
            cert_file_path = "conf/server/dummy_upstream_ca.crt"
            key_file_path = "conf/server/dummy_upstream_ca.key"
        }
    }
```
