% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrich.betareg.R
\name{enrich.betareg}
\alias{enrich.betareg}
\title{Enrich objects of class betareg}
\usage{
\method{enrich}{betareg}(object, with = "all", ...)
}
\arguments{
\item{object}{an object of class \code{\link[betareg]{betareg}}}

\item{with}{a character vector of options for the enrichment of \code{object}}

\item{...}{extra arguments to be passed to the
\code{compute_*} functions}
}
\value{
The object \code{object} of class \code{\link[betareg]{betareg}}
    with extra components. \code{get_enrichment_options.betareg()}
    returns the components and their descriptions.
}
\description{
Enrich objects of class \code{\link[betareg]{betareg}} with any or all of a
set of auxiliary functions, the expected information at the maximum
likelihood estimator, and the first term in the expansion of the
bias of the maximum likelihood estimator.
}
\details{
The \code{auxiliary_functions} component consists of any or all of the following functions:
\itemize{
\item \code{score}: the log-likelihood derivatives as a function of the model parameters; see \code{get_score_function.betareg}
\item \code{information}: the expected information as a function of the model parameters; see \code{\link{get_information_function.betareg}}
\item \code{bias}: the first-order term in the expansion of the bias of the maximum likelihood estimator as a function of the model parameters; see \code{\link{get_bias_function.betareg}}
\item \code{simulate}: a \code{\link{simulate}} function for \code{\link[betareg]{betareg}} objects that can simulate variates from the model at user-supplied parameter values for the regression parameters (default is the maximum likelihood estimates); see \code{\link{get_simulate_function.betareg}}
}
}
\examples{

\dontrun{
if (require("betareg")) {

   data("GasolineYield", package = "betareg")
   gy <- betareg(yield ~ batch + temp, data = GasolineYield)

   # Get a function that evaluates the expected information for gy at supplied parameter values
   gy_info <- get_information_function(gy)
.   # compare standard errors with what `summary` returns
   all.equal(sqrt(diag(solve(gy_info())))[1:11],
             coef(summary(gy))$mean[, 2], check.attributes = FALSE)
.   # evaluating at different parameter values
   gy_info(rep(1, length = 12))

   # Get a function that evaluates the first-order bias of gy at supplied parameter values
   gy_bias <- get_bias_function(gy)
   # compare with internal betareg implementation of bias correction
   gy_bc <- update(gy, type = "BC")
   all.equal(gy_bias(coef(gy)), gy_bc$bias, check.attributes = FALSE)

 }
}

}
