"""new one to one reference table

Revision ID: f0a32e2753f6
Revises: 182832ed9733
Create Date: 2023-09-01 16:11:53.865663+00:00

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'f0a32e2753f6'
down_revision = '182832ed9733'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('vulnerability_reference',
    sa.Column('create_date', sa.DateTime(), nullable=True),
    sa.Column('update_date', sa.DateTime(), nullable=True),
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.Text(), nullable=False),
    # sa.Column('type', sa.Enum('exploit', 'patch', 'other', name='reference_types'), nullable=True),
    sa.Column('vulnerability_id', sa.Integer(), nullable=False),
    sa.Column('creator_id', sa.Integer(), nullable=True),
    sa.Column('update_user_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['creator_id'], ['faraday_user.id'], ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['update_user_id'], ['faraday_user.id'], ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['vulnerability_id'], ['vulnerability.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id')
    )

    op.add_column('vulnerability_reference',
                  sa.Column(
                      'type',
                      sa.Enum('exploit', 'patch', 'other', name='reference_types'),
                      nullable=True
                  )
              )
    op.create_unique_constraint('uix_vulnerability_reference_table_vuln_id_name_type', 'vulnerability_reference',
                                ['name', 'type', 'vulnerability_id'])
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint('uix_vulnerability_reference_table_vuln_id_name_type', 'vulnerability_reference', type_='unique')
    op.drop_table('vulnerability_reference')
    # ### end Alembic commands ###
