#!/bin/sh
# $Id: MKterminfo.sh,v 1.28 2025/11/12 01:07:10 Branden.Robinson Exp $
#
# MKterminfo.sh -- generate terminfo.5 from Caps tabular data
#
#***************************************************************************
# Copyright 2018-2024,2025 Thomas E. Dickey                                *
# Copyright 1998-2003,2017 Free Software Foundation, Inc.                  *
#                                                                          *
# Permission is hereby granted, free of charge, to any person obtaining a  *
# copy of this software and associated documentation files (the            *
# "Software"), to deal in the Software without restriction, including      *
# without limitation the rights to use, copy, modify, merge, publish,      *
# distribute, distribute with modifications, sublicense, and/or sell       *
# copies of the Software, and to permit persons to whom the Software is    *
# furnished to do so, subject to the following conditions:                 *
#                                                                          *
# The above copyright notice and this permission notice shall be included  *
# in all copies or substantial portions of the Software.                   *
#                                                                          *
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS  *
# OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF               *
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.   *
# IN NO EVENT SHALL THE ABOVE COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,   *
# DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR    *
# OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR    *
# THE USE OR OTHER DEALINGS IN THE SOFTWARE.                               *
#                                                                          *
# Except as contained in this notice, the name(s) of the above copyright   *
# holders shall not be used in advertising or otherwise to promote the     *
# sale, use or other dealings in this Software without prior written       *
# authorization.                                                           *
#***************************************************************************
#
# This script takes terminfo.head and terminfo.tail and splices in between
# them a table derived from the Caps data file.  Besides avoiding having
# the docs fall out of sync with the table, this also lets us set up tbl
# commands for better formatting of the table.
#
# NOTE: The s in this script really are control characters.  It translates
#  to \n because I couldn't get used to inserting linefeeds directly.  There
# had better be no s in the table source text.
#
# keep the order independent of locale:
if test "${LANGUAGE+set}"    = set; then LANGUAGE=C;    export LANGUAGE;    fi
if test "${LANG+set}"        = set; then LANG=C;        export LANG;        fi
if test "${LC_ALL+set}"      = set; then LC_ALL=C;      export LC_ALL;      fi
if test "${LC_MESSAGES+set}" = set; then LC_MESSAGES=C; export LC_MESSAGES; fi
if test "${LC_CTYPE+set}"    = set; then LC_CTYPE=C;    export LC_CTYPE;    fi
if test "${LC_COLLATE+set}"  = set; then LC_COLLATE=C;  export LC_COLLATE;  fi

# collect the command-line parameters of the script
head="$1"
shift
caps=
capstext=
while test $# -gt 1
do
	caps="$caps $1"
	capstext="$capstext, $1"
	shift
done
tail="$1"

MYTEMP=`mktemp -d 2>/dev/null`
if [ -z "$MYTEMP" ]
then
	MYTEMP=${TMPDIR:-/tmp}/ncurses$$
fi
mkdir -p "$MYTEMP" || failed "cannot mkdir $MYTEMP"
trap "rm -rf $MYTEMP; exit 1" HUP INT QUIT TERM
trap "rm -rf $MYTEMP" EXIT

temp=$MYTEMP/temp
pass1=$MYTEMP/pass1
pass2=$MYTEMP/pass2
pass3=$MYTEMP/pass3
sorted=$MYTEMP/sorted
unsorted=$MYTEMP/unsorted

cat <<EOF
'\\" t
.\\" DO NOT EDIT THIS FILE BY HAND!
.\\" man/MKterminfo.sh generated it from:
.\\"   terminfo.head$capstext,
.\\"   and terminfo.tail.
.\\"
.\\" Note: this document must be run through tbl before nroff or troff.
.\\" Some man(1) programs recognize the token in the first-line comment
.\\" as directing them to arrange such a pipeline.
EOF

cat "$head"

cat >$pass1 <<EOF
/%%-STOP-HERE-%%/q
/^#%center/s, expand,,
/^#%lw25/s, lw6 , lw7 ,
/^#%/s/#%//p
/^#/d
s/[	][	]*/	/g
s/$/T}/
s/	[A-Z0-9_()\-][A-Z0-9_()\-]*	[0-9\-][0-9\-]*	[Y\-][B\-][C\-][G\-][EK\-]\**	/	T{\\
.na\
/
s/	bool	/	/p
s/	num	/	/p
s/	str	/	/p
EOF

echo 's/^$/../' > $pass2

sed -n -f $pass1 $caps | sed -f $pass2 | tr "\134" "\006" >$unsorted

rm -f $sorted
rm -f $temp
saved=no
while true
do
	data=
	read data
	test -z "$data" && break
	case "$data" in #(vi
	**) #(vi
		echo "$data" >>$temp
		saved=yes
		;;
	*)
		if test $saved = yes ; then
			saved=no
			sort $temp >>$sorted
			rm -f $temp
		fi
		echo "$data" >>$sorted
		;;
	esac
done <$unsorted
test $saved = yes && sort $temp >>$sorted

sed -e 's/^\.\.$//' $sorted | tr "\005\006" "\012\134" | sed -e '/^$/d'

cat > $pass3 << "EOF"
/^center expand;/s, expand,,
/^\.TS/,/^\\/s, lw[1-9][0-9]*\., l.,
EOF

sed	-f $pass3 "$tail"
