#ifndef _UTIL_H_
#define _UTIL_H_

#include <unistd.h>

#define FILENAME_MAX_LEN 0x80
#define KERNEL_VERSION_SIZE_BUFFER 512
#define ARRAY_SIZE(x) (sizeof(x) / sizeof((x)[0]))

struct kernel_info {
	const char* kernel_version;
	uint64_t io_ring_ctx_ref_free;
	uint64_t io_rsrc_node_ref_zero;
	uint64_t modprobe_path;
};

extern struct kernel_info kernels[];
extern int kernel;

void new_ns(void);
void generate_table_name(char table_name[8]);
void set_cpu_affinity(int cpu_n, pid_t pid);
struct utsname* get_kernel_version(void);
int detect_versions(void);
char *generate_tmp_filename(void);

#endif /* _UTIL_H_ */
