/*-
 * Copyright (C) 2008 Erik Larsson
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package org.catacombae.hfsexplorer.types.resff;

import java.io.PrintStream;
import org.catacombae.csjc.PrintableStruct;
import org.catacombae.csjc.StaticStruct;
import org.catacombae.hfsexplorer.Util;

/** This class was generated by CStructToJavaClass. */
public class ReferenceListEntry implements StaticStruct, PrintableStruct {
    /*
     * struct ReferenceListEntry
     * size: 12 bytes
     * description: 
     * 
     * BP  Size  Type      Identifier          Description                                                         
     * ------------------------------------------------------------------------------------------------------------
     * 0   2     UInt16    resourceID          // Resource ID                                                      
     * 2   2     UInt16    resourceNameOffset  // Offset from beginning of resource name list to resource name     
     * 4   1     UInt8     resourceAttributes  // Resource attributes                                              
     * 5   1*3   UInt8[3]  resourceDataOffset  // Offset from beginning of resource data to data for this resource.
     * 8   4     UInt32    reserved1           // Reserved for handle to resource.                                 
     */
    
    public static final int STRUCTSIZE = 12;
    
    private final byte[] resourceID = new byte[2];
    private final byte[] resourceNameOffset = new byte[2];
    private final byte[] resourceAttributes = new byte[1];
    private final byte[] resourceDataOffset = new byte[1*3];
    private final byte[] reserved1 = new byte[4];
    
    public ReferenceListEntry(byte[] data, int offset) {
	System.arraycopy(data, offset+0, resourceID, 0, 2);
	System.arraycopy(data, offset+2, resourceNameOffset, 0, 2);
	System.arraycopy(data, offset+4, resourceAttributes, 0, 1);
	System.arraycopy(data, offset+5, resourceDataOffset, 0, 1*3);
	System.arraycopy(data, offset+8, reserved1, 0, 4);
    }
    
    public static int length() { return STRUCTSIZE; }
    
    /** // Resource ID */
    public short getResourceID() { return Util.readShortBE(resourceID); }
    /** // Offset from beginning of resource name list to resource name */
    public short getResourceNameOffset() { return Util.readShortBE(resourceNameOffset); }
    /** // Resource attributes */
    public byte getResourceAttributes() { return Util.readByteBE(resourceAttributes); }
    /** // Offset from beginning of resource data to data for this resource. */
    public int getResourceDataOffset() {
        // 24-bit integers is a somewhat special situation...
        byte[] temp = new byte[4];
        temp[0] = 0;
        System.arraycopy(resourceDataOffset, 0, temp, 1, resourceDataOffset.length);
        return Util.readIntBE(temp);
    }

    /** // Reserved for handle to resource. */
    public int getReserved1() { return Util.readIntBE(reserved1); }
    
    public void printFields(PrintStream ps, String prefix) {
	ps.println(prefix + " resourceID: " + getResourceID());
	ps.println(prefix + " resourceNameOffset: " + getResourceNameOffset());
	ps.println(prefix + " resourceAttributes: " + getResourceAttributes());
	ps.println(prefix + " resourceDataOffset: " + getResourceDataOffset());
	ps.println(prefix + " reserved1: " + getReserved1());
    }
    
    public void print(PrintStream ps, String prefix) {
	ps.println(prefix + "ReferenceListEntry:");
	printFields(ps, prefix);
    }
    
    public byte[] getBytes() {
	byte[] result = new byte[length()];
	int offset = 0;
	System.arraycopy(this.resourceID, 0, result, offset, this.resourceID.length); offset += this.resourceID.length;
	System.arraycopy(this.resourceNameOffset, 0, result, offset, this.resourceNameOffset.length); offset += this.resourceNameOffset.length;
	System.arraycopy(this.resourceAttributes, 0, result, offset, this.resourceAttributes.length); offset += this.resourceAttributes.length;
	System.arraycopy(this.resourceDataOffset, 0, result, offset, this.resourceDataOffset.length); offset += this.resourceDataOffset.length;
	System.arraycopy(this.reserved1, 0, result, offset, this.reserved1.length); offset += this.reserved1.length;
	return result;
    }

    public int size() {
        return length();
    }
}
