/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.jparted.lib.ps.gpt;

import org.catacombae.hfsexplorer.partitioning.GUIDPartitionTable;
import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.jparted.lib.DataLocator;
import org.catacombae.jparted.lib.ps.Partition;
import org.catacombae.jparted.lib.ps.PartitionSystemHandler;
import org.catacombae.jparted.lib.ps.StandardPartition;

public class GPTHandler
extends PartitionSystemHandler {
    private DataLocator partitionData;

    public GPTHandler(DataLocator partitionData) {
        this.partitionData = partitionData;
    }

    public long getPartitionCount() {
        GUIDPartitionTable gpt = this.readPartitionTable();
        return gpt.getUsedPartitionCount();
    }

    public Partition[] getPartitions() {
        GUIDPartitionTable partitionTable = this.readPartitionTable();
        Partition[] result = new Partition[partitionTable.getUsedPartitionCount()];
        org.catacombae.hfsexplorer.partitioning.Partition[] parts = partitionTable.getUsedPartitionEntries();
        for (int i = 0; i < result.length; ++i) {
            result[i] = new StandardPartition(parts[i].getStartOffset(), parts[i].getLength(), parts[i].getType());
        }
        return result;
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GUIDPartitionTable readPartitionTable() {
        ReadableRandomAccessStream llf = null;
        try {
            llf = this.partitionData.createReadOnlyFile();
            GUIDPartitionTable gpt = new GUIDPartitionTable(llf, 0);
            if (gpt.isValid()) {
                GUIDPartitionTable gUIDPartitionTable = gpt;
                return gUIDPartitionTable;
            }
            GUIDPartitionTable gUIDPartitionTable = null;
            return gUIDPartitionTable;
        }
        finally {
            if (llf != null) {
                llf.close();
            }
        }
    }
}

