/* ###
 * IP: GHIDRA
 * REVIEWED: YES
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ghidra.app.plugin.core.string;

import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;

import java.util.List;

public class StringEventsTask extends Task {

	private StringTableModel stringModel;
	private List<StringEvent> list;
	private StringTableOptions options;

	public StringEventsTask(StringTableModel stringModel, StringTableOptions options,
			List<StringEvent> list) {
		super("Updating Strings Table", false, true, true);
		this.stringModel = stringModel;
		this.options = options;
		this.list = list;
	}

	@Override
	public void run(TaskMonitor monitor) {
		for (StringEvent event : list) {
			event.process(stringModel, options);
		}
	}

}
