/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.fs;

import org.catacombae.hfsexplorer.Util;
import org.catacombae.hfsexplorer.fs.BaseHFSAllocationFileView;
import org.catacombae.hfsexplorer.fs.BaseHFSFileSystemView;
import org.catacombae.hfsexplorer.fs.CharsetStringCodec;
import org.catacombae.hfsexplorer.fs.ImplHFSAllocationFileView;
import org.catacombae.hfsexplorer.fs.MutableStringCodec;
import org.catacombae.hfsexplorer.io.ReadableRandomAccessSubstream;
import org.catacombae.hfsexplorer.types.hfs.BTHdrRec;
import org.catacombae.hfsexplorer.types.hfs.CatKeyRec;
import org.catacombae.hfsexplorer.types.hfs.ExtKeyRec;
import org.catacombae.hfsexplorer.types.hfs.MasterDirectoryBlock;
import org.catacombae.hfsexplorer.types.hfs.NodeDescriptor;
import org.catacombae.hfsexplorer.types.hfscommon.CommonBTHeaderNode;
import org.catacombae.hfsexplorer.types.hfscommon.CommonBTHeaderRecord;
import org.catacombae.hfsexplorer.types.hfscommon.CommonBTNodeDescriptor;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSCatalogIndexNode;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSCatalogKey;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSCatalogLeafNode;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSCatalogLeafRecord;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSCatalogNodeID;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSCatalogString;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSExtentIndexNode;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSExtentKey;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSExtentLeafNode;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSForkType;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSVolumeHeader;
import org.catacombae.hfsexplorer.types.hfsplus.JournalInfoBlock;
import org.catacombae.io.Readable;
import org.catacombae.io.ReadableConcatenatedStream;
import org.catacombae.io.ReadableRandomAccessStream;

public class ImplHFSFileSystemView
extends BaseHFSFileSystemView {
    private static final CommonHFSCatalogString EMPTY_STRING = CommonHFSCatalogString.createHFS(new byte[0]);
    protected static final BaseHFSFileSystemView.CatalogOperations HFS_OPERATIONS = new BaseHFSFileSystemView.CatalogOperations(){

        public CommonHFSCatalogIndexNode newCatalogIndexNode(byte[] data, int offset, int nodeSize, CommonBTHeaderRecord bthr) {
            return CommonHFSCatalogIndexNode.createHFS(data, offset, nodeSize);
        }

        public CommonHFSCatalogKey newCatalogKey(CommonHFSCatalogNodeID nodeID, CommonHFSCatalogString searchString, CommonBTHeaderRecord bthr) {
            return CommonHFSCatalogKey.create(new CatKeyRec((int)nodeID.toLong(), searchString.getStringBytes()));
        }

        public CommonHFSCatalogLeafNode newCatalogLeafNode(byte[] data, int offset, int nodeSize, CommonBTHeaderRecord bthr) {
            return CommonHFSCatalogLeafNode.createHFS(data, offset, nodeSize);
        }

        public CommonHFSCatalogLeafRecord newCatalogLeafRecord(byte[] data, int offset, CommonBTHeaderRecord bthr) {
            return CommonHFSCatalogLeafRecord.createHFS(data, offset, data.length - offset);
        }
    };
    private final MutableStringCodec<CharsetStringCodec> stringCodec;

    public ImplHFSFileSystemView(ReadableRandomAccessStream hfsFile, long fsOffset, boolean cachingEnabled, String encodingName) {
        this(hfsFile, fileReadOffset, HFS_OPERATIONS, cachingEnabled, encodingName);
    }

    protected ImplHFSFileSystemView(ReadableRandomAccessStream hfsFile, long fsOffset, BaseHFSFileSystemView.CatalogOperations catOps, boolean cachingEnabled, String encodingName) {
        super(hfsFile, fsOffset, catOps, cachingEnabled);
        this.stringCodec = new MutableStringCodec<CharsetStringCodec>(new CharsetStringCodec(encodingName));
    }

    public MasterDirectoryBlock getMasterDirectoryBlock() {
        byte[] currentBlock = new byte[512];
        this.hfsFile.readFrom(this.fsOffset + 1024L, currentBlock);
        return new MasterDirectoryBlock(currentBlock, 0);
    }

    public CommonHFSVolumeHeader getVolumeHeader() {
        return CommonHFSVolumeHeader.create(this.getMasterDirectoryBlock());
    }

    protected CommonBTNodeDescriptor getNodeDescriptor(Readable rd) {
        byte[] data = new byte[NodeDescriptor.length()];
        rd.readFully(data);
        return this.createCommonBTNodeDescriptor(data, 0);
    }

    protected CommonBTHeaderRecord getHeaderRecord(Readable rd) {
        byte[] data = new byte[BTHdrRec.length()];
        rd.readFully(data);
        BTHdrRec bthr = new BTHdrRec(data, 0);
        return CommonBTHeaderRecord.create(bthr);
    }

    protected CommonBTNodeDescriptor createCommonBTNodeDescriptor(byte[] currentNodeData, int i) {
        NodeDescriptor nd = new NodeDescriptor(currentNodeData, i);
        return CommonBTNodeDescriptor.create(nd);
    }

    protected CommonHFSExtentIndexNode createCommonHFSExtentIndexNode(byte[] currentNodeData, int i, int nodeSize) {
        return CommonHFSExtentIndexNode.createHFS(currentNodeData, i, nodeSize);
    }

    protected CommonHFSExtentLeafNode createCommonHFSExtentLeafNode(byte[] currentNodeData, int i, int nodeSize) {
        return CommonHFSExtentLeafNode.createHFS(currentNodeData, i, nodeSize);
    }

    protected CommonHFSExtentKey createCommonHFSExtentKey(CommonHFSForkType forkType, CommonHFSCatalogNodeID fileID, int startBlock) {
        byte forkTypeByte;
        if (startBlock < Short.MIN_VALUE || startBlock > Short.MAX_VALUE) {
            throw new IllegalArgumentException("start block out of range for short (signed 16-bit integer)");
        }
        short startBlockShort = (short)startBlock;
        switch (forkType) {
            case DATA_FORK: {
                forkTypeByte = 0;
                break;
            }
            case RESOURCE_FORK: {
                forkTypeByte = -1;
                break;
            }
            default: {
                throw new RuntimeException("Invalid fork type");
            }
        }
        ExtKeyRec key = new ExtKeyRec(forkTypeByte, (int)fileID.toLong(), startBlockShort);
        return CommonHFSExtentKey.create(key);
    }

    protected CommonHFSCatalogNodeID getCommonHFSCatalogNodeID(CommonHFSCatalogNodeID.ReservedID requestedNodeID) {
        return CommonHFSCatalogNodeID.getHFSReservedID(requestedNodeID);
    }

    public JournalInfoBlock getJournalInfoBlock() {
        return null;
    }

    public void setStringEncoding(String encodingName) {
        this.stringCodec.setDecoder(new CharsetStringCodec(encodingName));
    }

    public String getStringEncoding() {
        return this.stringCodec.getDecoder().getCharsetName();
    }

    public CommonHFSCatalogString encodeString(String str) {
        byte[] bytes = this.stringCodec.encode(str);
        return CommonHFSCatalogString.createHFS(bytes);
    }

    public String decodeString(CommonHFSCatalogString str) {
        if (str instanceof CommonHFSCatalogString.HFSImplementation) {
            return this.stringCodec.decode(str.getStringBytes());
        }
        throw new RuntimeException("Invalid string type: " + str.getClass());
    }

    protected CommonBTHeaderNode createCommonBTHeaderNode(byte[] currentNodeData, int offset, int nodeSize) {
        return CommonBTHeaderNode.createHFS(currentNodeData, offset, nodeSize);
    }

    public BaseHFSAllocationFileView getAllocationFileView() {
        MasterDirectoryBlock mdb = this.getMasterDirectoryBlock();
        int numAllocationBlocks = Util.unsign(mdb.getDrNmAlBlks());
        int volumeBitmapSize = numAllocationBlocks / 8 + (numAllocationBlocks % 8 != 0 ? 1 : 0);
        ReadableConcatenatedStream volumeBitmapStream = new ReadableConcatenatedStream(new ReadableRandomAccessSubstream(this.hfsFile), this.fsOffset + (long)(512 * Util.unsign(mdb.getDrVBMSt())), volumeBitmapSize);
        return new ImplHFSAllocationFileView(this, (ReadableRandomAccessStream)volumeBitmapStream);
    }

    public CommonHFSCatalogString getEmptyString() {
        return EMPTY_STRING;
    }
}

