/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.csjc.structelements;

import java.util.LinkedList;
import org.catacombae.csjc.structelements.Array;
import org.catacombae.csjc.structelements.Endianness;
import org.catacombae.csjc.structelements.IntegerField;
import org.catacombae.csjc.structelements.IntegerFieldBits;
import org.catacombae.csjc.structelements.Signedness;
import org.catacombae.csjc.structelements.StructElement;

public class ArrayBuilder {
    private final String typeName;
    private final LinkedList<StructElement> elements = new LinkedList();

    public ArrayBuilder(String typeName) {
        this.typeName = typeName;
    }

    public void add(StructElement ... elements) {
        for (StructElement element : elements) {
            this.elements.add(element);
        }
    }

    public void addSIntBE(byte[] data) {
        this.addSIntBE(data, 0, data.length);
    }

    public void addSIntLE(byte[] data) {
        this.addSIntLE(data, 0, data.length);
    }

    public void addUIntBE(byte[] data) {
        this.addUIntBE(data, 0, data.length);
    }

    public void addUIntLE(byte[] data) {
        this.addUIntLE(data, 0, data.length);
    }

    public void addSIntBE(byte[] data, int offset, int length) {
        this.addInt(data, offset, length, Signedness.SIGNED, Endianness.BIG_ENDIAN);
    }

    public void addSIntLE(byte[] data, int offset, int length) {
        this.addInt(data, offset, length, Signedness.SIGNED, Endianness.LITTLE_ENDIAN);
    }

    public void addUIntBE(byte[] data, int offset, int length) {
        this.addInt(data, offset, length, Signedness.UNSIGNED, Endianness.BIG_ENDIAN);
    }

    public void addUIntLE(byte[] data, int offset, int length) {
        this.addInt(data, offset, length, Signedness.UNSIGNED, Endianness.LITTLE_ENDIAN);
    }

    private void addInt(byte[] data, int offset, int length, Signedness signedness, Endianness endianness) {
        switch (length) {
            case 1: {
                this.add(new IntegerField(data, offset, IntegerFieldBits.BITS_8, signedness, endianness));
                break;
            }
            case 2: {
                this.add(new IntegerField(data, offset, IntegerFieldBits.BITS_16, signedness, endianness));
                break;
            }
            case 4: {
                this.add(new IntegerField(data, offset, IntegerFieldBits.BITS_32, signedness, endianness));
                break;
            }
            case 8: {
                this.add(new IntegerField(data, offset, IntegerFieldBits.BITS_64, signedness, endianness));
                break;
            }
            default: {
                throw new IllegalArgumentException("You supplied a " + length * 8 + "-bit value. Only 64, 32, 16 and 8-bit values are supported.");
            }
        }
    }

    public Array getResult() {
        return new Array(this.typeName, this.elements.toArray(new StructElement[this.elements.size()]));
    }
}

