/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.templates;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.PropertyResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.jface.text.templates.persistence.TemplateReaderWriter;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.connection.DBPDataSourceProviderDescriptor;
import org.jkiss.dbeaver.model.impl.preferences.SimplePreferenceStore;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.preferences.PreferenceStoreDelegate;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.ReaderWriterLock;
import org.osgi.framework.Bundle;

public class SQLTemplateStore
extends TemplateStore {
    public static final String TEMPLATES_CONFIG_XML = "templates.xml";
    private static final Log log = Log.getLog(SQLTemplateStore.class);
    public static final String PREF_STORE_KEY = "org.jkiss.dbeaver.core.sql_templates";
    private final ReaderWriterLock<?> rwLock = new ReaderWriterLock(() -> null);
    private final CustomTemplatesStore customTemplatesStore;

    private SQLTemplateStore(ContextTypeRegistry registry, CustomTemplatesStore customTemplatesStore) {
        super(registry, (IPreferenceStore)new PreferenceStoreDelegate((DBPPreferenceStore)customTemplatesStore), PREF_STORE_KEY);
        this.customTemplatesStore = customTemplatesStore;
    }

    private ReaderWriterLock<?> lock() {
        return this.rwLock;
    }

    @NotNull
    public Set<String> getCustomTemplateNames() {
        try {
            String pref = (String)this.lock().computeReading(o -> this.customTemplatesStore.getString(PREF_STORE_KEY));
            if (pref != null && !pref.trim().isEmpty()) {
                StringReader input = new StringReader(pref);
                TemplateReaderWriter reader = new TemplateReaderWriter();
                return Stream.of(reader.read((Reader)input)).map(t -> t.getTemplate().getName()).collect(Collectors.toSet());
            }
        }
        catch (IOException ex) {
            log.error((Object)"Failed to load custom template names", (Throwable)ex);
        }
        return Collections.emptySet();
    }

    @NotNull
    public static SQLTemplateStore createInstance(@NotNull ContextTypeRegistry registry) {
        return new SQLTemplateStore(registry, new CustomTemplatesStore());
    }

    public void reload() throws IOException {
        this.lock().execWriting(o -> {
            this.customTemplatesStore.loadTemplatesConfig();
            super.load();
        });
    }

    protected void loadContributedTemplates() throws IOException {
        this.lock().execWriting(o -> {
            Collection<TemplatePersistenceData> contributed = this.readContributedTemplates();
            for (TemplatePersistenceData data : contributed) {
                this.internalAdd(data);
            }
        });
    }

    private Collection<TemplatePersistenceData> readContributedTemplates() throws IOException {
        ArrayList<TemplatePersistenceData> templates = new ArrayList<TemplatePersistenceData>();
        this.readIncludedTemplates("org.jkiss.dbeaver.ui.editors.sql", templates, "templates/default-templates.xml", "$nl$/templates/default-templates.properties");
        for (DBPDataSourceProviderDescriptor provider : DBWorkbench.getPlatform().getDataSourceProviderRegistry().getDataSourceProviders()) {
            this.readIncludedTemplates(provider.getPluginId(), templates, "templates/" + provider.getId() + "-templates.xml", "$nl$/templates/" + provider.getId() + "-templates.properties");
        }
        return templates;
    }

    private void readIncludedTemplates(String contributorId, Collection<TemplatePersistenceData> templates, String file, String translations) throws IOException {
        Bundle plugin;
        URL url;
        if (file != null && (url = FileLocator.find((Bundle)(plugin = Platform.getBundle((String)contributorId)), (IPath)Path.fromOSString((String)file), null)) != null) {
            URL bundleURL;
            PropertyResourceBundle bundle = null;
            if (translations != null && (bundleURL = FileLocator.find((Bundle)plugin, (IPath)Path.fromOSString((String)translations), null)) != null) {
                InputStream bundleStream = bundleURL.openStream();
                try {
                    bundle = new PropertyResourceBundle(bundleStream);
                }
                finally {
                    ContentUtils.close((Closeable)bundleStream);
                }
            }
            BufferedInputStream stream = new BufferedInputStream(url.openStream());
            try {
                TemplatePersistenceData[] datas;
                TemplateReaderWriter reader = new TemplateReaderWriter();
                TemplatePersistenceData[] templatePersistenceDataArray = datas = reader.read((InputStream)stream, bundle);
                int n = datas.length;
                int n2 = 0;
                while (n2 < n) {
                    TemplatePersistenceData data = templatePersistenceDataArray[n2];
                    if (data.isCustom()) {
                        if (data.getId() == null) {
                            log.error((Object)"No template id specified");
                        } else {
                            log.error((Object)("Template " + data.getTemplate().getName() + " deleted"));
                        }
                    } else if (this.validateTemplate(data.getTemplate())) {
                        templates.add(data);
                    }
                    ++n2;
                }
            }
            finally {
                ContentUtils.close((Closeable)stream);
            }
        }
    }

    private boolean validateTemplate(Template template) {
        String contextTypeId = template.getContextTypeId();
        if (!this.contextExists(contextTypeId)) {
            return false;
        }
        if (this.getRegistry() != null) {
            try {
                this.getRegistry().getContextType(contextTypeId).validate(template.getPattern());
            }
            catch (TemplateException e) {
                log.error((Object)("Template '" + template.getName() + "' validation failed"), (Throwable)e);
                return false;
            }
        }
        return true;
    }

    private boolean contextExists(String contextTypeId) {
        return contextTypeId != null && (this.getRegistry() == null || this.getRegistry().getContextType(contextTypeId) != null);
    }

    protected void handleException(IOException x) {
        log.error((Object)x);
    }

    public void load() throws IOException {
        this.lock().execWriting(o -> super.load());
    }

    public void save() throws IOException {
        this.lock().execWriting(o -> super.save());
    }

    public void restoreDefaults(boolean doSave) {
        this.lock().execWriting(o -> super.restoreDefaults(doSave));
    }

    public void restoreDefaults() {
        this.lock().execWriting(o -> super.restoreDefaults());
    }

    public void add(TemplatePersistenceData data) {
        this.lock().execWriting(o -> super.add(data));
    }

    public void add(org.eclipse.text.templates.TemplatePersistenceData data) {
        this.lock().execWriting(o -> super.add(data));
    }

    public void delete(TemplatePersistenceData data) {
        this.lock().execWriting(o -> super.delete(data));
    }

    public void delete(org.eclipse.text.templates.TemplatePersistenceData data) {
        this.lock().execWriting(o -> super.delete(data));
    }

    public TemplatePersistenceData[] getTemplateData(boolean includeDeleted) {
        return (TemplatePersistenceData[])this.lock().computeReading(o -> super.getTemplateData(includeDeleted));
    }

    public TemplatePersistenceData getTemplateData(String id) {
        return (TemplatePersistenceData)this.lock().computeReading(o -> super.getTemplateData(id));
    }

    protected void internalAdd(TemplatePersistenceData data) {
        this.lock().execWriting(o -> super.internalAdd(data));
    }

    protected void internalAdd(org.eclipse.text.templates.TemplatePersistenceData data) {
        this.lock().execWriting(o -> super.internalAdd(data));
    }

    public void restoreDeleted() {
        this.lock().execWriting(o -> super.restoreDeleted());
    }

    public Template[] getTemplates() {
        return (Template[])this.lock().computeReading(o -> super.getTemplates());
    }

    public Template[] getTemplates(String contextTypeId) {
        return (Template[])this.lock().computeReading(o -> super.getTemplates(contextTypeId));
    }

    public Template findTemplate(String name) {
        return (Template)this.lock().computeReading(o -> super.findTemplate(name));
    }

    public Template findTemplate(String name, String contextTypeId) {
        return (Template)this.lock().computeReading(o -> super.findTemplate(name, contextTypeId));
    }

    public Template findTemplateById(String id) {
        return (Template)this.lock().computeReading(o -> super.findTemplateById(id));
    }

    private static class CustomTemplatesStore
    extends SimplePreferenceStore {
        private CustomTemplatesStore() {
            super(DBWorkbench.getPlatform().getPreferenceStore());
            this.loadTemplatesConfig();
        }

        public void loadTemplatesConfig() {
            try {
                String content = DBWorkbench.getPlatform().getProductConfigurationController().loadConfigurationFile(SQLTemplateStore.TEMPLATES_CONFIG_XML);
                this.clear();
                if (CommonUtils.isNotEmpty((String)content)) {
                    this.setValue(SQLTemplateStore.PREF_STORE_KEY, content);
                }
            }
            catch (DBException e) {
                log.error((Object)e);
            }
        }

        public void save() throws IOException {
            if (!DBWorkbench.getPlatform().getWorkspace().hasRealmPermission("configuration-manager")) {
                log.warn((Object)"The user has no permission to save sql templates configuration");
                return;
            }
            String templatesConfig = this.getString(SQLTemplateStore.PREF_STORE_KEY);
            try {
                DBWorkbench.getPlatform().getProductConfigurationController().saveConfigurationFile(SQLTemplateStore.TEMPLATES_CONFIG_XML, templatesConfig);
            }
            catch (DBException e) {
                log.warn((Object)"Can't save template configuration", (Throwable)e);
            }
        }
    }
}

