/*
 * Decompiled with CFR 0.152.
 */
package org.cugos.wkg;

import java.util.ArrayList;
import java.util.List;
import org.cugos.wkg.CircularString;
import org.cugos.wkg.CompoundCurve;
import org.cugos.wkg.Coordinate;
import org.cugos.wkg.Curve;
import org.cugos.wkg.CurvePolygon;
import org.cugos.wkg.Dimension;
import org.cugos.wkg.Geometry;
import org.cugos.wkg.GeometryCollection;
import org.cugos.wkg.LineString;
import org.cugos.wkg.LinearRing;
import org.cugos.wkg.MultiCurve;
import org.cugos.wkg.MultiLineString;
import org.cugos.wkg.MultiPoint;
import org.cugos.wkg.MultiPolygon;
import org.cugos.wkg.MultiSurface;
import org.cugos.wkg.Point;
import org.cugos.wkg.PolyHedralSurface;
import org.cugos.wkg.Polygon;
import org.cugos.wkg.Surface;
import org.cugos.wkg.Tin;
import org.cugos.wkg.Triangle;
import org.cugos.wkg.Writer;

public class WKTWriter
implements Writer<String> {
    private final boolean useInnerParensForMultiPoints;

    public WKTWriter() {
        this(false);
    }

    public WKTWriter(boolean useInnerParensForMultiPoints) {
        this.useInnerParensForMultiPoints = useInnerParensForMultiPoints;
    }

    @Override
    public String write(Geometry g) {
        return this.write(g, true, true);
    }

    @Override
    public String getName() {
        return "WKT";
    }

    public String write(Geometry g, boolean includeSrid, boolean includeDimension) {
        if (g instanceof Point) {
            return this.write((Point)g, includeSrid, includeDimension);
        }
        if (g instanceof LineString) {
            return this.write((LineString)g, includeSrid, includeDimension);
        }
        if (g instanceof LinearRing) {
            return this.write((LinearRing)g, includeSrid, includeDimension);
        }
        if (g instanceof Triangle) {
            return this.write((Triangle)g, includeSrid, includeDimension);
        }
        if (g instanceof Polygon) {
            return this.write((Polygon)g, includeSrid, includeDimension);
        }
        if (g instanceof MultiPoint) {
            return this.write((MultiPoint)g, includeSrid, includeDimension);
        }
        if (g instanceof MultiLineString) {
            return this.write((MultiLineString)g, includeSrid, includeDimension);
        }
        if (g instanceof MultiPolygon) {
            return this.write((MultiPolygon)g, includeSrid, includeDimension);
        }
        if (g instanceof GeometryCollection) {
            return this.write((GeometryCollection)g, includeSrid, includeDimension);
        }
        if (g instanceof CircularString) {
            return this.write((CircularString)g, includeSrid, includeDimension);
        }
        if (g instanceof CurvePolygon) {
            return this.write((CurvePolygon)g, includeSrid, includeDimension);
        }
        if (g instanceof MultiCurve) {
            return this.write((MultiCurve)g, includeSrid, includeDimension);
        }
        if (g instanceof PolyHedralSurface) {
            return this.write((PolyHedralSurface)g, includeSrid, includeDimension);
        }
        if (g instanceof MultiSurface) {
            return this.write((MultiSurface)g, includeSrid, includeDimension);
        }
        if (g instanceof CompoundCurve) {
            return this.write((CompoundCurve)g, includeSrid, includeDimension);
        }
        if (g instanceof Tin) {
            return this.write((Tin)g, includeSrid, includeDimension);
        }
        throw new IllegalArgumentException("Unknown Geometry! " + g.getClass().getName());
    }

    public String write(Point p) {
        return this.write(p, true, true);
    }

    public String write(Point p, boolean includeSrid, boolean includeDimension) {
        Coordinate coordinate = p.getCoordinate();
        StringBuilder builder = new StringBuilder();
        if (includeSrid) {
            this.addSrid(p, builder);
        }
        builder.append("POINT");
        if (coordinate.isEmpty()) {
            builder.append(" EMPTY");
        } else {
            if (includeDimension) {
                this.addDimension(p, builder);
            }
            builder.append(" (");
            this.addCoordinate(coordinate, builder);
            builder.append(")");
        }
        return builder.toString();
    }

    public String write(LineString lineString) {
        return this.write(lineString, true, true);
    }

    public String write(LineString lineString, boolean includeSrid, boolean includeDimension) {
        List<Coordinate> coordinates = lineString.getCoordinates();
        StringBuilder builder = new StringBuilder();
        if (includeSrid) {
            this.addSrid(lineString, builder);
        }
        builder.append("LINESTRING");
        if (coordinates.isEmpty()) {
            builder.append(" EMPTY");
        } else {
            if (includeDimension) {
                this.addDimension(lineString, builder);
            }
            builder.append(" (");
            this.addCoordinates(coordinates, builder);
            builder.append(")");
        }
        return builder.toString();
    }

    public String write(LinearRing ring) {
        return this.write(ring, true, true);
    }

    public String write(LinearRing lineString, boolean includeSrid, boolean includeDimension) {
        List<Coordinate> coordinates = lineString.getCoordinates();
        StringBuilder builder = new StringBuilder();
        if (includeSrid) {
            this.addSrid(lineString, builder);
        }
        builder.append("LINEARRING");
        if (coordinates.isEmpty()) {
            builder.append(" EMPTY");
        } else {
            if (includeDimension) {
                this.addDimension(lineString, builder);
            }
            builder.append(" (");
            this.addCoordinates(coordinates, builder);
            builder.append(")");
        }
        return builder.toString();
    }

    public String write(MultiPoint mp) {
        return this.write(mp, true, true);
    }

    public String write(MultiPoint mp, boolean includeSrid, boolean includeDimension) {
        List<Point> points = mp.getPoints();
        ArrayList<Coordinate> coords = new ArrayList<Coordinate>();
        for (Point pt : points) {
            coords.add(pt.getCoordinate());
        }
        StringBuilder builder = new StringBuilder();
        if (includeSrid) {
            this.addSrid(mp, builder);
        }
        builder.append("MULTIPOINT");
        if (points.isEmpty()) {
            builder.append(" EMPTY");
        } else {
            if (includeDimension) {
                this.addDimension(mp, builder);
            }
            builder.append(" (");
            this.addCoordinates(coords, this.useInnerParensForMultiPoints, builder);
            builder.append(")");
        }
        return builder.toString();
    }

    public String write(Polygon p) {
        return this.write(p, true, true);
    }

    public String write(Polygon p, boolean includeSrid, boolean includeDimension) {
        StringBuilder builder = new StringBuilder();
        if (includeSrid) {
            this.addSrid(p, builder);
        }
        builder.append("POLYGON");
        if (p.getOuterLinearRing() == null || p.getOuterLinearRing().getCoordinates().isEmpty()) {
            builder.append(" EMPTY");
        } else {
            if (includeDimension) {
                this.addDimension(p, builder);
            }
            builder.append(" ((");
            this.addCoordinates(p.getOuterLinearRing().getCoordinates(), builder);
            builder.append(")");
            for (LinearRing ring : p.getInnerLinearRings()) {
                builder.append(", (");
                this.addCoordinates(ring.getCoordinates(), builder);
                builder.append(")");
            }
            builder.append(")");
        }
        return builder.toString();
    }

    public String write(MultiPolygon mp) {
        return this.write(mp, true, true);
    }

    public String write(MultiPolygon mp, boolean includeSrid, boolean includeDimension) {
        StringBuilder builder = new StringBuilder();
        if (includeSrid) {
            this.addSrid(mp, builder);
        }
        builder.append("MULTIPOLYGON");
        if (mp.getPolygons().isEmpty()) {
            builder.append(" EMPTY");
        } else {
            if (includeDimension) {
                this.addDimension(mp, builder);
            }
            builder.append(" (");
            boolean firstPoly = true;
            for (Polygon polygon : mp.getPolygons()) {
                if (!firstPoly) {
                    builder.append(", ");
                } else {
                    firstPoly = false;
                }
                builder.append("((");
                this.addCoordinates(polygon.getOuterLinearRing().getCoordinates(), builder);
                builder.append(")");
                for (LinearRing ring : polygon.getInnerLinearRings()) {
                    builder.append(", (");
                    this.addCoordinates(ring.getCoordinates(), builder);
                    builder.append(")");
                }
                builder.append(")");
            }
            builder.append(")");
        }
        return builder.toString();
    }

    public String write(MultiLineString ml) {
        return this.write(ml, true, true);
    }

    public String write(MultiLineString ml, boolean includeSrid, boolean includeDimension) {
        StringBuilder builder = new StringBuilder();
        if (includeSrid) {
            this.addSrid(ml, builder);
        }
        builder.append("MULTILINESTRING");
        if (ml.getLineStrings().isEmpty()) {
            builder.append(" EMPTY");
        } else {
            if (includeDimension) {
                this.addDimension(ml, builder);
            }
            builder.append(" (");
            boolean firstLine = true;
            for (LineString line : ml.getLineStrings()) {
                if (!firstLine) {
                    builder.append(", ");
                } else {
                    firstLine = false;
                }
                builder.append("(");
                this.addCoordinates(line.getCoordinates(), builder);
                builder.append(")");
            }
            builder.append(")");
        }
        return builder.toString();
    }

    public String write(GeometryCollection gc) {
        return this.write(gc, true, true);
    }

    public String write(GeometryCollection gc, boolean includeSrid, boolean includeDimension) {
        StringBuilder builder = new StringBuilder();
        if (includeSrid) {
            this.addSrid(gc, builder);
        }
        builder.append("GEOMETRYCOLLECTION");
        if (gc.getGeometries().isEmpty()) {
            builder.append(" EMPTY");
        } else {
            if (includeDimension) {
                this.addDimension(gc, builder);
            }
            builder.append(" (");
            boolean first = true;
            for (Geometry g : gc.getGeometries()) {
                if (!first) {
                    builder.append(", ");
                } else {
                    first = false;
                }
                builder.append(this.write(g, false, false));
            }
            builder.append(")");
        }
        return builder.toString();
    }

    public String write(Triangle t) {
        return this.write(t, true, true);
    }

    public String write(Triangle t, boolean includeSrid, boolean includeDimension) {
        StringBuilder builder = new StringBuilder();
        if (includeSrid) {
            this.addSrid(t, builder);
        }
        builder.append("TRIANGLE");
        if (t.getOuterLinearRing().getCoordinates().isEmpty()) {
            builder.append(" EMPTY");
        } else {
            if (includeDimension) {
                this.addDimension(t, builder);
            }
            builder.append(" ((");
            this.addCoordinates(t.getOuterLinearRing().getCoordinates(), builder);
            builder.append(")");
            for (LinearRing ring : t.getInnerLinearRings()) {
                builder.append(", (");
                this.addCoordinates(ring.getCoordinates(), builder);
                builder.append(")");
            }
            builder.append(")");
        }
        return builder.toString();
    }

    public String write(CircularString circularString) {
        return this.write(circularString, true, true);
    }

    public String write(CircularString circularString, boolean includeSrid, boolean includeDimension) {
        List<Coordinate> coordinates = circularString.getCoordinates();
        StringBuilder builder = new StringBuilder();
        if (includeSrid) {
            this.addSrid(circularString, builder);
        }
        builder.append("CIRCULARSTRING");
        if (coordinates.isEmpty()) {
            builder.append(" EMPTY");
        } else {
            if (includeDimension) {
                this.addDimension(circularString, builder);
            }
            builder.append(" (");
            this.addCoordinates(coordinates, builder);
            builder.append(")");
        }
        return builder.toString();
    }

    public String write(Tin tin) {
        return this.write(tin, true, true);
    }

    public String write(Tin tin, boolean includeSrid, boolean includeDimension) {
        StringBuilder builder = new StringBuilder();
        if (includeSrid) {
            this.addSrid(tin, builder);
        }
        builder.append("TIN");
        if (tin.getTriangles().isEmpty()) {
            builder.append(" EMPTY");
        } else {
            if (includeDimension) {
                this.addDimension(tin, builder);
            }
            builder.append(" (");
            boolean first = true;
            for (Triangle t : tin.getTriangles()) {
                if (!first) {
                    builder.append(", ");
                } else {
                    first = false;
                }
                builder.append("((");
                this.addCoordinates(t.getOuterLinearRing().getCoordinates(), builder);
                builder.append(")");
                for (LinearRing ring : t.getInnerLinearRings()) {
                    builder.append(", (");
                    this.addCoordinates(ring.getCoordinates(), builder);
                    builder.append(")");
                }
                builder.append(")");
            }
            builder.append(")");
        }
        return builder.toString();
    }

    public String write(CompoundCurve compoundCurve) {
        return this.write(compoundCurve, true, true);
    }

    public String write(CompoundCurve compoundCurve, boolean includeSrid, boolean includeDimension) {
        StringBuilder builder = new StringBuilder();
        if (includeSrid) {
            this.addSrid(compoundCurve, builder);
        }
        builder.append("COMPOUNDCURVE");
        if (compoundCurve.getCurves().isEmpty()) {
            builder.append(" EMPTY");
        } else {
            if (includeDimension) {
                this.addDimension(compoundCurve, builder);
            }
            builder.append(" (");
            boolean first = true;
            for (Curve curve : compoundCurve.getCurves()) {
                if (!first) {
                    builder.append(", ");
                } else {
                    first = false;
                }
                if (curve instanceof LineString) {
                    builder.append("(");
                    this.addCoordinates(((LineString)curve).getCoordinates(), builder);
                    builder.append(")");
                    continue;
                }
                if (!(curve instanceof CircularString)) continue;
                builder.append(this.write((CircularString)curve, false, false));
            }
            builder.append(")");
        }
        return builder.toString();
    }

    public String write(CurvePolygon p) {
        return this.write(p, true, true);
    }

    public String write(CurvePolygon p, boolean includeSrid, boolean includeDimension) {
        StringBuilder builder = new StringBuilder();
        if (includeSrid) {
            this.addSrid(p, builder);
        }
        builder.append("CURVEPOLYGON");
        if (p.getOuterCurve() == null || p.getOuterCurve().isEmpty()) {
            builder.append(" EMPTY");
        } else {
            if (includeDimension) {
                this.addDimension(p, builder);
            }
            builder.append(" (");
            Curve outerCurve = p.getOuterCurve();
            if (outerCurve instanceof LineString) {
                LineString line = (LineString)outerCurve;
                builder.append("(");
                this.addCoordinates(line.getCoordinates(), builder);
                builder.append(")");
            } else if (outerCurve instanceof CircularString) {
                builder.append(this.write((CircularString)outerCurve, false, false));
            } else if (outerCurve instanceof CompoundCurve) {
                builder.append(this.write((CompoundCurve)outerCurve, false, false));
            }
            for (Curve curve : p.getInnerCurves()) {
                builder.append(", ");
                if (curve instanceof LineString) {
                    LineString line = (LineString)curve;
                    builder.append("(");
                    this.addCoordinates(line.getCoordinates(), builder);
                    builder.append(")");
                    continue;
                }
                if (curve instanceof CircularString) {
                    builder.append(this.write((CircularString)curve, false, false));
                    continue;
                }
                if (!(curve instanceof CompoundCurve)) continue;
                builder.append(this.write((CompoundCurve)curve, false, false));
            }
            builder.append(")");
        }
        return builder.toString();
    }

    public String write(MultiCurve mc) {
        return this.write(mc, true, true);
    }

    public String write(MultiCurve mc, boolean includeSrid, boolean includeDimension) {
        StringBuilder builder = new StringBuilder();
        if (includeSrid) {
            this.addSrid(mc, builder);
        }
        builder.append("MULTICURVE");
        if (mc.isEmpty()) {
            builder.append(" EMPTY");
        } else {
            if (includeDimension) {
                this.addDimension(mc, builder);
            }
            builder.append(" (");
            boolean first = true;
            for (Curve c : mc.getCurves()) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                if (c instanceof LineString) {
                    LineString line = (LineString)c;
                    builder.append("(");
                    this.addCoordinates(line.getCoordinates(), builder);
                    builder.append(")");
                    continue;
                }
                if (c instanceof CircularString) {
                    builder.append(this.write((CircularString)c, false, false));
                    continue;
                }
                if (!(c instanceof CompoundCurve)) continue;
                builder.append(this.write((CompoundCurve)c, false, false));
            }
            builder.append(")");
        }
        return builder.toString();
    }

    public String write(PolyHedralSurface phs) {
        return this.write(phs, true, true);
    }

    public String write(PolyHedralSurface phs, boolean includeSrid, boolean includeDimension) {
        StringBuilder builder = new StringBuilder();
        if (includeSrid) {
            this.addSrid(phs, builder);
        }
        builder.append("POLYHEDRALSURFACE");
        if (phs.getPolygons().isEmpty()) {
            builder.append(" EMPTY");
        } else {
            if (includeDimension) {
                this.addDimension(phs, builder);
            }
            builder.append(" (");
            boolean firstPoly = true;
            for (Polygon polygon : phs.getPolygons()) {
                if (!firstPoly) {
                    builder.append(", ");
                } else {
                    firstPoly = false;
                }
                builder.append("((");
                this.addCoordinates(polygon.getOuterLinearRing().getCoordinates(), builder);
                builder.append(")");
                for (LinearRing ring : polygon.getInnerLinearRings()) {
                    builder.append(", (");
                    this.addCoordinates(ring.getCoordinates(), builder);
                    builder.append(")");
                }
                builder.append(")");
            }
            builder.append(")");
        }
        return builder.toString();
    }

    public String write(MultiSurface ms) {
        return this.write(ms, true, true);
    }

    public String write(MultiSurface ms, boolean includeSrid, boolean includeDimension) {
        StringBuilder builder = new StringBuilder();
        if (includeSrid) {
            this.addSrid(ms, builder);
        }
        builder.append("MULTISURFACE");
        if (ms.isEmpty()) {
            builder.append(" EMPTY");
        } else {
            if (includeDimension) {
                this.addDimension(ms, builder);
            }
            builder.append(" (");
            boolean first = true;
            for (Surface s : ms.getSurfaces()) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                if (s instanceof Polygon) {
                    this.addPolygonText((Polygon)s, builder);
                    continue;
                }
                if (!(s instanceof CurvePolygon)) continue;
                builder.append(this.write((CurvePolygon)s, false, false));
            }
            builder.append(")");
        }
        return builder.toString();
    }

    protected void addCoordinates(List<Coordinate> coordinates, StringBuilder builder) {
        this.addCoordinates(coordinates, false, builder);
    }

    protected void addCoordinates(List<Coordinate> coordinates, boolean innerParens, StringBuilder builder) {
        boolean first = true;
        for (Coordinate coordinate : coordinates) {
            if (!first) {
                builder.append(", ");
            } else {
                first = false;
            }
            if (innerParens) {
                builder.append("(");
            }
            this.addCoordinate(coordinate, builder);
            if (!innerParens) continue;
            builder.append(")");
        }
    }

    protected void addCoordinate(Coordinate coordinate, StringBuilder builder) {
        builder.append(coordinate.getX());
        builder.append(" ");
        builder.append(coordinate.getY());
        if (coordinate.getDimension() == Dimension.TwoMeasured) {
            builder.append(" ").append(coordinate.getM());
        } else if (coordinate.getDimension() == Dimension.Three) {
            builder.append(" ").append(coordinate.getZ());
        } else if (coordinate.getDimension() == Dimension.ThreeMeasured) {
            builder.append(" ").append(coordinate.getZ());
            builder.append(" ").append(coordinate.getM());
        }
    }

    protected void addSrid(Geometry g, StringBuilder builder) {
        if (g.getSrid() != null) {
            builder.append("SRID=").append(g.getSrid()).append(";");
        }
    }

    protected void addDimension(Geometry g, StringBuilder builder) {
        if (g.getDimension() == Dimension.TwoMeasured) {
            builder.append(" M");
        } else if (g.getDimension() == Dimension.Three) {
            builder.append(" Z");
        } else if (g.getDimension() == Dimension.ThreeMeasured) {
            builder.append(" ZM");
        }
    }

    protected void addPolygonText(Polygon polygon, StringBuilder builder) {
        builder.append("((");
        this.addCoordinates(polygon.getOuterLinearRing().getCoordinates(), builder);
        builder.append(")");
        for (LinearRing ring : polygon.getInnerLinearRings()) {
            builder.append(", (");
            this.addCoordinates(ring.getCoordinates(), builder);
            builder.append(")");
        }
        builder.append(")");
    }
}

