/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.compatibility.state;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.compatibility.state.PlatformBundleListener;
import org.eclipse.osgi.compatibility.state.ReadOnlyState;
import org.eclipse.osgi.compatibility.state.StateConverter;
import org.eclipse.osgi.container.Module;
import org.eclipse.osgi.container.ModuleContainer;
import org.eclipse.osgi.container.ModuleDatabase;
import org.eclipse.osgi.container.ModuleRevision;
import org.eclipse.osgi.internal.framework.BundleContextImpl;
import org.eclipse.osgi.internal.framework.EquinoxContainer;
import org.eclipse.osgi.internal.module.ResolverImpl;
import org.eclipse.osgi.internal.resolver.StateHelperImpl;
import org.eclipse.osgi.internal.resolver.StateObjectFactoryImpl;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.DisabledInfo;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.resolver.Resolver;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateHelper;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.hooks.resolver.ResolverHookFactory;
import org.osgi.framework.wiring.BundleRevision;

public class PlatformAdminImpl
implements PlatformAdmin {
    private final StateObjectFactory factory = new StateObjectFactoryImpl();
    private final Object monitor = new Object();
    private EquinoxContainer equinoxContainer;
    private BundleContext bc;
    private State systemState;
    private PlatformBundleListener synchronizer;
    private ServiceRegistration<PlatformAdmin> reg;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start(BundleContext context) {
        Object object = this.monitor;
        synchronized (object) {
            this.equinoxContainer = ((BundleContextImpl)context).getContainer();
            this.bc = context;
        }
        this.reg = context.registerService(PlatformAdmin.class, (Object)this, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop(BundleContext context) {
        Object object = this.monitor;
        synchronized (object) {
            if (this.synchronizer != null) {
                context.removeBundleListener((BundleListener)this.synchronizer);
                context.removeFrameworkListener((FrameworkListener)this.synchronizer);
            }
            this.synchronizer = null;
            this.systemState = null;
        }
        this.reg.unregister();
    }

    public State getState() {
        return this.getState(true);
    }

    public State getState(boolean mutable) {
        if (mutable) {
            return this.factory.createState(this.getSystemState());
        }
        return new ReadOnlyState(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    State getSystemState() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.systemState == null) {
                this.systemState = this.createSystemState();
            }
            return this.systemState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getTimeStamp() {
        Object object = this.monitor;
        synchronized (object) {
            return this.equinoxContainer.getStorage().getModuleDatabase().getRevisionsTimestamp();
        }
    }

    private State createSystemState() {
        State state = this.factory.createState(true);
        StateConverter converter = new StateConverter(state);
        ModuleDatabase database = this.equinoxContainer.getStorage().getModuleDatabase();
        database.readLock();
        try {
            ModuleContainer container = this.equinoxContainer.getStorage().getModuleContainer();
            List modules = this.equinoxContainer.getStorage().getModuleContainer().getModules();
            for (Module module : modules) {
                ModuleRevision current = module.getCurrentRevision();
                BundleDescription description = converter.createDescription((BundleRevision)current);
                state.addBundle(description);
            }
            state.setPlatformProperties(this.asDictionary(this.equinoxContainer.getConfiguration().getInitialConfig()));
            this.synchronizer = new PlatformBundleListener(state, converter, database, container);
            state.setResolverHookFactory((ResolverHookFactory)this.synchronizer);
            this.bc.addBundleListener((BundleListener)this.synchronizer);
            this.bc.addFrameworkListener((FrameworkListener)this.synchronizer);
            state.resolve();
            state.setTimeStamp(database.getRevisionsTimestamp());
        }
        finally {
            database.readUnlock();
        }
        return state;
    }

    private Dictionary<String, Object> asDictionary(Map<String, ?> map) {
        return new Hashtable<String, Object>(map);
    }

    public StateHelper getStateHelper() {
        return StateHelperImpl.getInstance();
    }

    public void commit(State state) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public Resolver getResolver() {
        return this.createResolver();
    }

    public Resolver createResolver() {
        return new ResolverImpl(false);
    }

    public StateObjectFactory getFactory() {
        return this.factory;
    }

    public void addDisabledInfo(DisabledInfo disabledInfo) {
        throw new UnsupportedOperationException();
    }

    public void removeDisabledInfo(DisabledInfo disabledInfo) {
        throw new UnsupportedOperationException();
    }
}

