/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.erd.layout.algorithm.direct;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.EdgeList;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;
import org.jkiss.dbeaver.ui.editors.erd.layout.algorithm.direct.DummyEdgePart;

public class ClusterEdgeCreator {
    private static final int INITIAL_RECURSION_DEPTH = 3;
    private NodeList nodeList;
    private EdgeList edgeList;
    private DirectedGraph graph;
    private List<Node> encountered = new ArrayList<Node>();
    private List<Cluster> clusters = new ArrayList<Cluster>();
    private Cluster currentCluster = null;

    public void visit(DirectedGraph graph) {
        try {
            this.graph = graph;
            this.nodeList = graph.nodes;
            this.edgeList = graph.edges;
            for (Node node : this.nodeList) {
                if (this.encountered.contains(node)) continue;
                this.currentCluster = new Cluster();
                this.clusters.add(this.currentCluster);
                this.encountered.add(node);
                this.currentCluster.set.add(node);
                int depth = 3;
                this.recursivelyAddToCluster(node, depth);
            }
            this.coalesceRemainingClusters();
            this.joinClusters();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
    }

    private void coalesceRemainingClusters() {
    }

    private void joinClusters() {
        if (this.clusters.size() > 1) {
            Node sourceNode = null;
            Node targetNode = null;
            for (Cluster cluster : this.clusters) {
                if (sourceNode != null) {
                    targetNode = cluster.set.get(0);
                    this.newDummyEdge(sourceNode, targetNode);
                }
                sourceNode = cluster.set.get(cluster.set.size() - 1);
            }
        }
    }

    private void recursivelyAddToCluster(Node node, int depth) {
        if (depth <= 3) {
            ++depth;
            EdgeList incoming = node.incoming;
            for (Edge edge : incoming) {
                Node incomingNode = edge.source;
                if (this.encountered.contains(incomingNode)) continue;
                this.encountered.add(incomingNode);
                this.currentCluster.set.add(incomingNode);
                this.recursivelyAddToCluster(incomingNode, depth);
            }
            EdgeList outgoing = node.outgoing;
            for (Edge edge : outgoing) {
                Node outgoingNode = edge.target;
                if (this.encountered.contains(outgoingNode)) continue;
                this.encountered.add(outgoingNode);
                this.currentCluster.set.add(outgoingNode);
                this.recursivelyAddToCluster(outgoingNode, depth);
            }
        }
    }

    private Edge newDummyEdge(Node sourceNode, Node targetNode) {
        DummyEdgePart edgePart = new DummyEdgePart();
        Edge edge = new Edge((Object)edgePart, sourceNode, targetNode);
        edge.weight = 2;
        this.edgeList.add((Object)edge);
        return edge;
    }

    private class Cluster {
        List<Node> set = new ArrayList<Node>();

        private Cluster() {
        }

        public String toString() {
            return this.set.toString();
        }
    }
}

