//go:build !windows
// +build !windows

// Copyright (c) 2016-2025 Tigera, Inc. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package nfnl

// Message Types
const (
	IPCTNL_MSG_CT_NEW = iota
	IPCTNL_MSG_CT_GET
	IPCTNL_MSG_CT_DELETE
	IPCTNL_MSG_CT_GET_CTRZERO
	IPCTNL_MSG_CT_GET_STATS_CPU
	IPCTNL_MSG_CT_GET_STATS
	IPCTNL_MSG_CT_GET_DYING
	IPCTNL_MSG_CT_GET_UNCONFIRMED

	IPCTNL_MSG_MAX
)

const (
	IPCTNL_MSG_EXP_NEW = iota
	IPCTNL_MSG_EXP_GET
	IPCTNL_MSG_EXP_DELETE
	IPCTNL_MSG_EXP_GET_STATS_CPU

	IPCTNL_MSG_EXP_MAX
)

// Attributes
const (
	CTA_UNSPEC = iota
	CTA_TUPLE_ORIG
	CTA_TUPLE_REPLY
	CTA_STATUS
	CTA_PROTOINFO
	CTA_HELP
	CTA_NAT_SRC
	CTA_TIMEOUT
	CTA_MARK
	CTA_COUNTERS_ORIG
	CTA_COUNTERS_REPLY
	CTA_USE
	CTA_ID
	CTA_NAT_DST
	CTA_TUPLE_MASTER
	CTA_SEQ_ADJ_ORIG
	CTA_SEQ_ADJ_REPLY
	CTA_SECMARK
	CTA_ZONE
	CTA_SECCTX
	CTA_TIMESTAMP
	CTA_MARK_MASK
	CTA_LABELS
	CTA_LABELS_MASK
	__CTA_MAX
)
const CTA_MAX = __CTA_MAX - 1

// Some Attribute Aliases
const (
	CTA_NAT               = CTA_NAT_SRC
	CTA_NAT_SEQ_ADJ_ORIG  = CTA_SEQ_ADJ_ORIG
	CTA_NAT_SEQ_ADJ_REPLY = CTA_SEQ_ADJ_REPLY
)

const (
	CTA_TUPLE_UNSPEC = iota
	CTA_TUPLE_IP
	CTA_TUPLE_PROTO
	CTA_TUPLE_ZONE
	__CTA_TUPLE_MAX
)
const CTA_TUPLE_MAX = __CTA_TUPLE_MAX - 1

const (
	CTA_IP_UNSPEC = iota
	CTA_IP_V4_SRC
	CTA_IP_V4_DST
	CTA_IP_V6_SRC
	CTA_IP_V6_DST
	__CTA_IP_MAX
)
const CTA_IP_MAX = __CTA_IP_MAX - 1

const (
	CTA_PROTO_UNSPEC = iota
	CTA_PROTO_NUM
	CTA_PROTO_SRC_PORT
	CTA_PROTO_DST_PORT
	CTA_PROTO_ICMP_ID
	CTA_PROTO_ICMP_TYPE
	CTA_PROTO_ICMP_CODE
	CTA_PROTO_ICMPV6_ID
	CTA_PROTO_ICMPV6_TYPE
	CTA_PROTO_ICMPV6_CODE
	__CTA_PROTO_MAX
)
const CTA_PROTO_MAX = __CTA_PROTO_MAX - 1

const (
	CTA_PROTOINFO_UNSPEC = iota
	CTA_PROTOINFO_TCP
	CTA_PROTOINFO_DCCP
	CTA_PROTOINFO_SCTP
	__CTA_PROTOINFO_MAX
)
const CTA_PROTOINFO_MAX = __CTA_PROTOINFO_MAX - 1

const (
	CTA_PROTOINFO_TCP_UNSPEC = iota
	CTA_PROTOINFO_TCP_STATE
	CTA_PROTOINFO_TCP_WSCALE_ORIGINAL
	CTA_PROTOINFO_TCP_WSCALE_REPLY
	CTA_PROTOINFO_TCP_FLAGS_ORIGINAL
	CTA_PROTOINFO_TCP_FLAGS_REPLY
	__CTA_PROTOINFO_TCP_MAX
)
const CTA_PROTOINFO_TCP_MAX = __CTA_PROTOINFO_TCP_MAX - 1

const (
	CTA_PROTOINFO_DCCP_UNSPEC = iota
	CTA_PROTOINFO_DCCP_STATE
	CTA_PROTOINFO_DCCP_ROLE
	CTA_PROTOINFO_DCCP_HANDSHAKE_SEQ
	__CTA_PROTOINFO_DCCP_MAX
)
const CTA_PROTOINFO_DCCP_MAX = __CTA_PROTOINFO_DCCP_MAX - 1

const (
	CTA_PROTOINFO_SCTP_UNSPEC = iota
	CTA_PROTOINFO_SCTP_STATE
	CTA_PROTOINFO_SCTP_VTAG_ORIGINAL
	CTA_PROTOINFO_SCTP_VTAG_REPLY
	__CTA_PROTOINFO_SCTP_MAX
)
const CTA_PROTOINFO_SCTP_MAX = __CTA_PROTOINFO_SCTP_MAX - 1

const (
	CTA_COUNTERS_UNSPEC = iota
	CTA_COUNTERS_PACKETS
	CTA_COUNTERS_BYTES
	CTA_COUNTERS32_PACKETS
	CTA_COUNTERS32_BYTES
	__CTA_COUNTERS_MAX
)
const CTA_COUNTERS_MAX = __CTA_COUNTERS_MAX - 1

const (
	CTA_TIMESTAMP_UNSPEC = iota
	CTA_TIMESTAMP_START
	CTA_TIMESTAMP_STOP
	__CTA_TIMESTAMP_MAX
)
const CTA_TIMESTAMP_MAX = __CTA_TIMESTAMP_MAX - 1

const (
	CTA_NAT_UNSPEC = iota
	CTA_NAT_V4_MINIP
	CTA_NAT_V4_MAXIP
	CTA_NAT_PROTO
	CTA_NAT_V6_MINIP
	CTA_NAT_V6_MAXIP
	__CTA_NAT_MAX
)
const CTA_NAT_MAX = __CTA_NAT_MAX - 1
const CTA_NAT_MINIP = CTA_NAT_V4_MINIP
const CTA_NAT_MAXIP = CTA_NAT_V4_MAXIP

const (
	CTA_PROTONAT_UNSPEC = iota
	CTA_PROTONAT_PORT_MIN
	CTA_PROTONAT_PORT_MAX
	__CTA_PROTONAT_MAX
)
const CTA_PROTONAT_MAX = __CTA_PROTONAT_MAX - 1

const (
	CTA_SEQADJ_UNSPEC = iota
	CTA_SEQADJ_CORRECTION_POS
	CTA_SEQADJ_OFFSET_BEFORE
	CTA_SEQADJ_OFFSET_AFTER
	__CTA_SEQADJ_MAX
)
const CTA_SEQADJ_MAX = __CTA_SEQADJ_MAX - 1

const (
	CTA_NAT_SEQ_UNSPEC = iota
	CTA_NAT_SEQ_CORRECTION_POS
	CTA_NAT_SEQ_OFFSET_BEFORE
	CTA_NAT_SEQ_OFFSET_AFTER
	__CTA_NAT_SEQ_MAX
)
const CTA_NAT_SEQ_MAX = __CTA_NAT_SEQ_MAX - 1

const (
	CTA_EXPECT_UNSPEC = iota
	CTA_EXPECT_MASTER
	CTA_EXPECT_TUPLE
	CTA_EXPECT_MASK
	CTA_EXPECT_TIMEOUT
	CTA_EXPECT_ID
	CTA_EXPECT_HELP_NAME
	CTA_EXPECT_ZONE
	CTA_EXPECT_FLAGS
	CTA_EXPECT_CLASS
	CTA_EXPECT_NAT
	CTA_EXPECT_FN
	__CTA_EXPECT_MAX
)
const CTA_EXPECT_MAX = __CTA_EXPECT_MAX - 1

const (
	CTA_EXPECT_NAT_UNSPEC = iota
	CTA_EXPECT_NAT_DIR
	CTA_EXPECT_NAT_TUPLE
	__CTA_EXPECT_NAT_MAX
)
const CTA_EXPECT_NAT_MAX = __CTA_EXPECT_NAT_MAX - 1

const (
	CTA_HELP_UNSPEC = iota
	CTA_HELP_NAME
	CTA_HELP_INFO
	__CTA_HELP_MAX
)
const CTA_HELP_MAX = __CTA_HELP_MAX - 1

const (
	CTA_SECCTX_UNSPEC = iota
	CTA_SECCTX_NAME
	__CTA_SECCTX_MAX
)
const CTA_SECCTX_MAX = __CTA_SECCTX_MAX - 1

const (
	CTA_STATS_UNSPEC = iota
	CTA_STATS_SEARCHED
	CTA_STATS_FOUND
	CTA_STATS_NEW
	CTA_STATS_INVALID
	CTA_STATS_IGNORE
	CTA_STATS_DELETE
	CTA_STATS_DELETE_LIST
	CTA_STATS_INSERT
	CTA_STATS_INSERT_FAILED
	CTA_STATS_DROP
	CTA_STATS_EARLY_DROP
	CTA_STATS_ERROR
	CTA_STATS_SEARCH_RESTART
	__CTA_STATS_MAX
)
const CTA_STATS_MAX = __CTA_STATS_MAX - 1

const (
	CTA_STATS_GLOBAL_UNSPEC = iota
	CTA_STATS_GLOBAL_ENTRIES
	__CTA_STATS_GLOBAL_MAX
)
const CTA_STATS_GLOBAL_MAX = __CTA_STATS_GLOBAL_MAX - 1

const (
	CTA_STATS_EXP_UNSPEC = iota
	CTA_STATS_EXP_NEW
	CTA_STATS_EXP_CREATE
	CTA_STATS_EXP_DELETE
	__CTA_STATS_EXP_MAX
)
const CTA_STATS_EXP_MAX = __CTA_STATS_EXP_MAX - 1

// IP Conntrack Status Bits
const (
	IPS_EXPECTED_BIT = iota
	IPS_SEEN_REPLY_BIT
	IPS_ASSURED_BIT
	IPS_CONFIRMED_BIT
	IPS_SRC_NAT_BIT
	IPS_DST_NAT_BIT
	IPS_SEQ_ADJUST_BIT
	IPS_SRC_NAT_DONE_BIT
	IPS_DST_NAT_DONE_BIT
	IPS_DYING_BIT
	IPS_FIXED_TIMEOUT_BIT
	IPS_TEMPLATE_BIT
	IPS_UNTRACKED_BIT
)

// IP Conntrack Status Values
const (
	IPS_EXPECTED      = (1 << IPS_EXPECTED_BIT)
	IPS_SEEN_REPLY    = (1 << IPS_SEEN_REPLY_BIT)
	IPS_ASSURED       = (1 << IPS_ASSURED_BIT)
	IPS_CONFIRMED     = (1 << IPS_CONFIRMED_BIT)
	IPS_SRC_NAT       = (1 << IPS_SRC_NAT_BIT)
	IPS_DST_NAT       = (1 << IPS_DST_NAT_BIT)
	IPS_NAT_MASK      = (IPS_DST_NAT | IPS_SRC_NAT)
	IPS_SEQ_ADJUST    = (1 << IPS_SEQ_ADJUST_BIT)
	IPS_SRC_NAT_DONE  = (1 << IPS_SRC_NAT_DONE_BIT)
	IPS_DST_NAT_DONE  = (1 << IPS_DST_NAT_DONE_BIT)
	IPS_NAT_DONE_MASK = (IPS_DST_NAT_DONE | IPS_SRC_NAT_DONE)
	IPS_DYING         = (1 << IPS_DYING_BIT)
	IPS_FIXED_TIMEOUT = (1 << IPS_FIXED_TIMEOUT_BIT)
	IPS_TEMPLATE      = (1 << IPS_TEMPLATE_BIT)
	IPS_UNTRACKED     = (1 << IPS_UNTRACKED_BIT)
)

const (
	ICMP_PROTO = 1
	TCP_PROTO  = 6
	UDP_PROTO  = 17
)

// TCP Conntrack States
const (
	TCP_CONNTRACK_NONE = iota
	TCP_CONNTRACK_SYN_SENT
	TCP_CONNTRACK_SYN_RECV
	TCP_CONNTRACK_ESTABLISHED
	TCP_CONNTRACK_FIN_WAIT
	TCP_CONNTRACK_CLOSE_WAIT
	TCP_CONNTRACK_LAST_ACK
	TCP_CONNTRACK_TIME_WAIT
	TCP_CONNTRACK_CLOSE
	TCP_CONNTRACK_LISTEN
	TCP_CONNTRACK_MAX
	TCP_CONNTRACK_IGNORE
	TCP_CONNTRACK_RETRANS
	TCP_CONNTRACK_UNACK
	TCP_CONNTRACK_TIMEOUT_MAX
)
