/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.plugin;

import com.fluendo.jst.Buffer;
import com.fluendo.jst.Caps;
import com.fluendo.jst.Element;
import com.fluendo.jst.Event;
import com.fluendo.jst.Message;
import com.fluendo.jst.Pad;
import com.fluendo.plugin.KateDec;
import com.fluendo.plugin.OggPayload;
import com.fluendo.plugin.TheoraDec;
import com.fluendo.plugin.VorbisDec;
import com.fluendo.utils.Debug;
import com.fluendo.utils.MemUtils;
import com.jcraft.jogg.Packet;
import com.jcraft.jogg.Page;
import com.jcraft.jogg.StreamState;
import com.jcraft.jogg.SyncState;
import java.util.Vector;

public class OggDemux
extends Element {
    private SyncState oy;
    private OggChain chain = null;
    private Page og;
    private Packet op;
    private static final byte[] signature = new byte[]{79, 103, 103, 83};
    private static final byte[] fishead_signature = new byte[]{102, 105, 115, 104, 101, 97, 100};
    private static final byte[] cmml_signature = new byte[]{67, 77, 77, 76};
    private static final int TYPE_NEW = 0;
    private static final int TYPE_UNKNOWN = 1;
    private static final int TYPE_SKELETON = 2;
    private static final int TYPE_CMML = 3;
    private static final int TYPE_MEDIA = 4;
    private OggPayload[] payloads = new OggPayload[]{new TheoraDec(), new VorbisDec(), new KateDec()};
    private Pad sinkPad = new Pad(2, "sink"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean eventFunc(Event event) {
            switch (event.getType()) {
                case 1: {
                    if (OggDemux.this.chain != null) {
                        OggDemux.this.chain.forwardEvent(event);
                    }
                    Object object = this.streamLock;
                    synchronized (object) {
                        Debug.log(4, this + " synced");
                        break;
                    }
                }
                case 2: {
                    OggDemux.this.oy.reset();
                    if (OggDemux.this.chain == null) break;
                    OggDemux.this.chain.resetStreams();
                    OggDemux.this.chain.forwardEvent(event);
                    break;
                }
                case 4: {
                    break;
                }
                case 3: {
                    Debug.log(3, "ogg: got EOS");
                    if (OggDemux.this.chain != null) {
                        OggDemux.this.chain.forwardEvent(event);
                        break;
                    }
                    OggDemux.this.postMessage(Message.newError(this, "unsupported media type"));
                    break;
                }
                default: {
                    if (OggDemux.this.chain == null) break;
                    OggDemux.this.chain.forwardEvent(event);
                }
            }
            return true;
        }

        protected int chainFunc(Buffer buffer) {
            int n = 0;
            int n2 = OggDemux.this.oy.buffer(buffer.length);
            if (buffer.isFlagSet(1)) {
                Debug.log(3, "ogg: got discont");
                if (OggDemux.this.chain != null) {
                    OggDemux.this.chain.markDiscont();
                }
            }
            System.arraycopy(buffer.data, buffer.offset, ((OggDemux)OggDemux.this).oy.data, n2, buffer.length);
            OggDemux.this.oy.wrote(buffer.length);
            while (n == 0) {
                int n3 = OggDemux.this.oy.pageout(OggDemux.this.og);
                if (n3 == 0) break;
                if (n3 == -1) {
                    Debug.log(2, "ogg: pageout gave " + n3);
                    if (OggDemux.this.chain == null) continue;
                    OggDemux.this.chain.markDiscont();
                    continue;
                }
                int n4 = OggDemux.this.og.serialno();
                OggStream oggStream = null;
                if (OggDemux.this.chain != null) {
                    oggStream = OggDemux.this.chain.findStream(n4);
                }
                if (oggStream == null) {
                    if (OggDemux.this.chain != null && OggDemux.this.chain.isActive()) {
                        OggDemux.this.chain.deActivate();
                        OggDemux.this.chain = null;
                    }
                    if (OggDemux.this.chain == null) {
                        OggDemux.this.chain = new OggChain();
                    }
                    oggStream = new OggStream(n4);
                    OggDemux.this.chain.addStream(oggStream);
                }
                n = OggDemux.this.chain.pushPage(OggDemux.this.og, oggStream);
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean activateFunc(int n) {
            if (n == 0) {
                Pad pad = OggDemux.this.sinkPad;
                synchronized (pad) {
                    OggDemux.this.oy.reset();
                    if (OggDemux.this.chain != null) {
                        OggDemux.this.chain.deActivate();
                        OggDemux.this.chain = null;
                    }
                }
            }
            return true;
        }
    };

    private int combineFlows(OggStream oggStream, int n) {
        oggStream.lastRet = n;
        if (Pad.isFlowSuccess(n)) {
            return n;
        }
        if (n != -1) {
            return n;
        }
        if (this.chain != null) {
            int n2 = 0;
            while (n2 < this.chain.streams.size()) {
                OggStream oggStream2 = (OggStream)this.chain.streams.elementAt(n2);
                n = oggStream2.lastRet;
                if (n != -1) {
                    return n;
                }
                ++n2;
            }
        }
        return n;
    }

    public String getFactoryName() {
        return "oggdemux";
    }

    public String getMime() {
        return "application/ogg";
    }

    public int typeFind(byte[] byArray, int n, int n2) {
        if (MemUtils.startsWith(byArray, n, n2, signature)) {
            return 10;
        }
        return -1;
    }

    public OggDemux() {
        this.oy = new SyncState();
        this.og = new Page();
        this.op = new Packet();
        this.addPad(this.sinkPad);
    }

    static /* synthetic */ Packet access$9(OggDemux oggDemux) {
        return oggDemux.op;
    }

    class OggChain {
        private Vector streams = new Vector();
        private boolean active = false;
        private boolean synced = false;
        private long firstTs = -1L;

        public boolean isActive() {
            return this.active;
        }

        public void activate() {
            if (this.active) {
                return;
            }
            Debug.log(4, "activating chain");
            int n = 0;
            while (n < this.streams.size()) {
                OggStream oggStream = (OggStream)this.streams.elementAt(n);
                oggStream.activate();
                ++n;
            }
            this.active = true;
            OggDemux.this.noMorePads();
        }

        public void deActivate() {
            if (!this.active) {
                return;
            }
            Debug.log(4, "deActivating chain");
            int n = 0;
            while (n < this.streams.size()) {
                OggStream oggStream = (OggStream)this.streams.elementAt(n);
                oggStream.deActivate();
                ++n;
            }
            this.active = false;
        }

        public void reStart() {
            if (!this.active) {
                return;
            }
            if (this.firstTs == -1L) {
                long l = 0L;
                long l2 = Long.MAX_VALUE;
                int n = 0;
                while (n < this.streams.size()) {
                    OggStream oggStream = (OggStream)this.streams.elementAt(n);
                    if (oggStream.type == 4) {
                        long l3 = oggStream.getFirstTs();
                        l = Math.max(l, l3);
                        l2 = Math.min(l2, l3);
                    }
                    ++n;
                }
                this.firstTs = l;
            }
            int n = 0;
            while (n < this.streams.size()) {
                OggStream oggStream = (OggStream)this.streams.elementAt(n);
                oggStream.reStart(this.firstTs);
                ++n;
            }
        }

        public void addStream(OggStream oggStream) {
            this.streams.addElement(oggStream);
        }

        public void markDiscont() {
            this.synced = false;
            this.firstTs = -1L;
            int n = 0;
            while (n < this.streams.size()) {
                OggStream oggStream = (OggStream)this.streams.elementAt(n);
                oggStream.markDiscont();
                ++n;
            }
        }

        public OggStream findStream(int n) {
            OggStream oggStream = null;
            int n2 = 0;
            while (n2 < this.streams.size()) {
                oggStream = (OggStream)this.streams.elementAt(n2);
                if (oggStream.serialno == n) break;
                oggStream = null;
                ++n2;
            }
            return oggStream;
        }

        public void resetStreams() {
            int n = 0;
            while (n < this.streams.size()) {
                OggStream oggStream = (OggStream)this.streams.elementAt(n);
                oggStream.reset();
                ++n;
            }
        }

        public boolean forwardEvent(Event event) {
            int n = 0;
            while (n < this.streams.size()) {
                OggStream oggStream = (OggStream)this.streams.elementAt(n);
                oggStream.pushEvent(event);
                ++n;
            }
            return true;
        }

        public int pushPage(Page page, OggStream oggStream) {
            int n = 0;
            n = oggStream.pushPage(page);
            if (!this.synced) {
                boolean bl = true;
                boolean bl2 = false;
                int n2 = 0;
                while (n2 < this.streams.size()) {
                    OggStream oggStream2 = (OggStream)this.streams.elementAt(n2);
                    if (oggStream2.type == 4) {
                        bl2 = true;
                        bl = oggStream2.isComplete();
                        if (!bl) break;
                    }
                    ++n2;
                }
                if (bl && bl2) {
                    Debug.log(4, "streams synced");
                    this.activate();
                    this.reStart();
                    this.synced = true;
                }
            }
            return n;
        }
    }

    class OggStream
    extends Pad {
        public int serialno;
        public StreamState os;
        private Vector headers;
        private long baseTs;
        public boolean haveHeaders;
        public Vector queue;
        public boolean started;
        public boolean complete;
        public boolean discont;
        public boolean active;
        public boolean haveKeyframe;
        public boolean sentHeaders;
        public int type;
        public int lastRet;
        private OggPayload payload;

        public OggStream(int n) {
            super(1, "serial_" + n);
            this.serialno = n;
            this.os = new StreamState();
            this.os.init(n);
            this.os.reset();
            this.queue = new Vector();
            this.headers = new Vector();
            this.haveHeaders = false;
            this.haveKeyframe = false;
            this.payload = null;
            this.discont = true;
            this.complete = false;
            this.started = false;
            this.baseTs = -1L;
            this.lastRet = 0;
        }

        public void markDiscont() {
            this.discont = true;
            this.complete = false;
            this.haveKeyframe = false;
            this.started = false;
        }

        public void reset() {
            this.markDiscont();
            this.os.reset();
            this.lastRet = 0;
        }

        public boolean isComplete() {
            return this.complete;
        }

        public void activate() {
            if (this.active) {
                return;
            }
            this.sentHeaders = false;
            this.lastRet = 0;
            OggDemux.this.addPad(this);
            this.active = true;
        }

        public void deActivate() {
            if (!this.active) {
                return;
            }
            OggDemux.this.removePad(this);
            this.pushEvent(Event.newEOS());
            this.active = false;
        }

        public void reStart(long l) {
            Buffer buffer;
            int n;
            if (!this.active) {
                return;
            }
            if (this.baseTs == -1L) {
                this.baseTs = l;
            }
            long l2 = l - this.baseTs;
            Debug.log(4, this + " pushing segment start " + l + ", time " + l2);
            this.pushEvent(Event.newNewsegment(false, 3, l, -1L, l2));
            if (!this.sentHeaders) {
                n = 0;
                while (n < this.headers.size()) {
                    buffer = (Buffer)this.headers.elementAt(n);
                    buffer.setFlag(1, this.discont);
                    this.discont = false;
                    this.push(buffer);
                    ++n;
                }
                this.sentHeaders = true;
            }
            n = 0;
            while (n < this.queue.size()) {
                buffer = (Buffer)this.queue.elementAt(n);
                if (n == 0) {
                    Debug.log(4, this + " first data buffer: " + buffer.timestamp);
                }
                buffer.setFlag(1, this.discont);
                this.discont = false;
                this.push(buffer);
                ++n;
            }
            this.queue.setSize(0);
            this.started = true;
        }

        public long getFirstTs() {
            return this.payload.getFirstTs(this.queue);
        }

        private Buffer bufferFromPacket(Packet packet) {
            Buffer buffer = Buffer.create();
            buffer.copyData(packet.packet_base, packet.packet, packet.bytes);
            buffer.time_offset = packet.granulepos;
            buffer.timestamp = this.payload != null ? this.payload.granuleToTime(packet.granulepos) : -1L;
            buffer.setFlag(1, this.discont);
            buffer.setFlag(2, !this.payload.isKeyFrame(packet));
            return buffer;
        }

        private void initNewStream(Packet packet) {
            this.payload = null;
            int n = 0;
            while (n < OggDemux.this.payloads.length) {
                OggPayload oggPayload = OggDemux.this.payloads[n];
                if (oggPayload.isType(packet)) {
                    try {
                        this.payload = (OggPayload)oggPayload.getClass().newInstance();
                        this.type = 4;
                        String string = this.payload.getMime();
                        Debug.log(3, "new stream " + this.serialno + ", mime " + string);
                        this.setCaps(new Caps(string));
                        return;
                    }
                    catch (Exception exception) {}
                }
                ++n;
            }
            if (MemUtils.startsWith(packet.packet_base, packet.packet, packet.bytes, fishead_signature)) {
                this.type = 2;
                Debug.log(3, "ignoring skeleton stream " + this.serialno);
                OggDemux.this.postMessage(Message.newWarning(this, "ignoring skeleton stream " + this.serialno));
                return;
            }
            if (MemUtils.startsWith(packet.packet_base, packet.packet, packet.bytes, cmml_signature)) {
                this.type = 3;
                Debug.log(3, "ignoring CMML stream " + this.serialno);
                OggDemux.this.postMessage(Message.newWarning(this, "ignoring CMML stream " + this.serialno));
                return;
            }
            this.type = 1;
            Debug.log(3, "ignoring unknown stream " + this.serialno);
            OggDemux.this.postMessage(Message.newWarning(this, "ignoring unknown stream " + this.serialno));
        }

        public int pushPacket(Packet packet) {
            Buffer buffer;
            int n;
            if (this.type == 0) {
                this.initNewStream(packet);
            }
            if (this.type != 4) {
                this.complete = true;
                return 0;
            }
            if (!this.haveHeaders) {
                if (this.payload.isHeader(packet)) {
                    n = this.payload.takeHeader(packet);
                    if (n < 0) {
                        OggDemux.this.postMessage(Message.newError(this, "cannot read header"));
                        return -5;
                    }
                    buffer = this.bufferFromPacket(packet);
                    this.headers.addElement(buffer);
                    if (n > 0) {
                        this.haveHeaders = true;
                    }
                } else {
                    this.haveHeaders = true;
                }
            }
            if (this.haveHeaders) {
                if (!this.complete && this.payload.isDiscontinuous()) {
                    this.complete = true;
                }
                if (this.complete && this.started) {
                    buffer = this.bufferFromPacket(packet);
                    n = this.push(buffer);
                    return OggDemux.this.combineFlows(this, n);
                }
                if (this.haveKeyframe || this.payload.isKeyFrame(packet)) {
                    Buffer buffer2 = this.bufferFromPacket(packet);
                    this.queue.addElement(buffer2);
                    this.haveKeyframe = true;
                    if (packet.granulepos != -1L) {
                        this.complete = true;
                    }
                }
            }
            return 0;
        }

        /*
         * Unable to fully structure code
         */
        public int pushPage(Page var1_1) {
            var3_2 = 0;
            var2_3 = this.os.pagein(var1_1);
            if (var2_3 >= 0) ** GOTO lbl13
            System.err.println("Error reading first page of Ogg bitstream data.");
            OggDemux.this.postMessage(Message.newError(this, "Error reading first page of Ogg bitstream data."));
            return -5;
            while ((var2_3 = this.os.packetout(OggDemux.access$9(OggDemux.this))) != 0) {
                if (var2_3 == -1) {
                    Debug.log(2, "ogg error: packetout gave " + var2_3);
                    this.discont = true;
                } else {
                    var3_2 = this.pushPacket(OggDemux.access$9(OggDemux.this));
                }
lbl13:
                // 3 sources

                if (var3_2 == 0) continue;
            }
            return var3_2;
        }

        protected boolean eventFunc(Event event) {
            return OggDemux.this.sinkPad.pushEvent(event);
        }
    }
}

