#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2016 Antoine Le Gonidec <vv221@dotslashplay.it>
# SPDX-FileCopyrightText: © 2017 Mopi
set -o errexit

###
# Deponia series:
# - Deponia 1
# - Deponia 2
# - Deponia 3
# send your bug reports to bugs@dotslashplay.it
###

script_version=20240822.1

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID_DEPONIA1='deponia-1'
GAME_NAME_DEPONIA1='Deponia'

GAME_ID_DEPONIA2='deponia-2'
GAME_NAME_DEPONIA2='Deponia 2: Chaos on Deponia'

GAME_ID_DEPONIA3='deponia-3'
GAME_NAME_DEPONIA3='Deponia 3: Goodbye Deponia'

# Archives

## Deponia 1

ARCHIVE_BASE_DEPONIA1_GOG_0_NAME='gog_deponia_2.1.0.3.sh'
ARCHIVE_BASE_DEPONIA1_GOG_0_MD5='a3a21ba1c1ee68c9be2c755bd79e1b30'
ARCHIVE_BASE_DEPONIA1_GOG_0_SIZE='1800000'
ARCHIVE_BASE_DEPONIA1_GOG_0_VERSION='3.3.1357-gog2.1.0.3'
ARCHIVE_BASE_DEPONIA1_GOG_0_URL='https://www.gog.com/game/deponia'

## This DRM-free native Linux build is no longer available for sale from the Humble Store,
## they now only sell Steam keys for the Deponia games.
ARCHIVE_BASE_DEPONIA1_HUMBLE_0_NAME='Deponia_3.3.1358_Full_DEB_Multi_Daedalic_ESD.tar.gz'
ARCHIVE_BASE_DEPONIA1_HUMBLE_0_MD5='8ff4e21bbb4abcdc4059845acf7c7f04'
ARCHIVE_BASE_DEPONIA1_HUMBLE_0_VERSION='3.3.1358-humble160511'
ARCHIVE_BASE_DEPONIA1_HUMBLE_0_SIZE='1700000'

## Deponia 2

ARCHIVE_BASE_DEPONIA2_GOG_0_NAME='gog_deponia_2_chaos_on_deponia_2.1.0.3.sh'
ARCHIVE_BASE_DEPONIA2_GOG_0_MD5='7aa1251741a532e4b9f908a3af0d8f2a'
ARCHIVE_BASE_DEPONIA2_GOG_0_SIZE='3200000'
ARCHIVE_BASE_DEPONIA2_GOG_0_VERSION='3.3.2351-gog2.1.0.3'
ARCHIVE_BASE_DEPONIA2_GOG_0_URL='https://www.gog.com/game/deponia_2_chaos_on_deponia'

## This DRM-free native Linux build is no longer available for sale from the Humble Store,
## they now only sell Steam keys for the Deponia games.
ARCHIVE_BASE_DEPONIA2_HUMBLE_0_NAME='Deponia2_DEB_Full_3.2.2342_Multi_Daedalic_ESD.tar.gz'
ARCHIVE_BASE_DEPONIA2_HUMBLE_0_MD5='e7a71d5b8a83b2c2393095256b03553b'
ARCHIVE_BASE_DEPONIA2_HUMBLE_0_SIZE='3100000'
ARCHIVE_BASE_DEPONIA2_HUMBLE_0_VERSION='3.2.2342-humble'

## Optional icons pack
ARCHIVE_OPTIONAL_ICONS_0_NAME_DEPONIA2='deponia-2_icons.tar.gz'
ARCHIVE_OPTIONAL_ICONS_0_MD5_DEPONIA2='4469f0e85881f0db2c266dcb6222717c'
ARCHIVE_OPTIONAL_ICONS_0_URL_DEPONIA2='https://downloads.dotslashplay.it/resources/deponia-2'
CONTENT_ICONS_PATH_DEPONIA2='.'
CONTENT_ICONS_FILES_DEPONIA2='
16x16
32x32
48x48
256x256'

## Deponia 3

ARCHIVE_BASE_DEPONIA3_GOG_0_NAME='gog_deponia_3_goodbye_deponia_2.1.0.4.sh'
ARCHIVE_BASE_DEPONIA3_GOG_0_MD5='9af5c29790e629635d27bc9368299516'
ARCHIVE_BASE_DEPONIA3_GOG_0_SIZE='3900000'
ARCHIVE_BASE_DEPONIA3_GOG_0_VERSION='3.3.3335-gog2.1.0.4'
ARCHIVE_BASE_DEPONIA3_GOG_0_URL='https://www.gog.com/game/goodbye_deponia'

## This DRM-free native Linux build is no longer available for sale from the Humble Store,
## they now only sell Steam keys for the Deponia games.
ARCHIVE_BASE_DEPONIA3_HUMBLE_0_NAME='Deponia3_DEB_Full_3.2.3.3320_Multi_Daedalic_ESD.tar.gz'
ARCHIVE_BASE_DEPONIA3_HUMBLE_0_MD5='1fe92f0faf379541440895de68a1a14e'
ARCHIVE_BASE_DEPONIA3_HUMBLE_0_SIZE='3700000'
ARCHIVE_BASE_DEPONIA3_HUMBLE_0_VERSION='3.2.0.3320-humble'

## Optional icons pack
ARCHIVE_OPTIONAL_ICONS_0_NAME_DEPONIA3='deponia-3_icons.tar.gz'
ARCHIVE_OPTIONAL_ICONS_0_MD5_DEPONIA3='d57dfcd4b23ff2c7f4163b9db20329f2'
ARCHIVE_OPTIONAL_ICONS_0_URL_DEPONIA3='https://downloads.dotslashplay.it/resources/deponia-3'
CONTENT_ICONS_PATH_DEPONIA3='.'
CONTENT_ICONS_FILES_DEPONIA3='
16x16
32x32
48x48
256x256'


VISIONAIRE_NAME_DEPONIA1='Deponia'
VISIONAIRE_NAME_DEPONIA2='Deponia2'
VISIONAIRE_NAME_DEPONIA3='Deponia3'

CONTENT_PATH_DEFAULT_DEPONIA1_GOG='data/noarch/game'
CONTENT_PATH_DEFAULT_DEPONIA1_HUMBLE='Deponia'
CONTENT_PATH_DEFAULT_DEPONIA2_GOG='data/noarch/game'
CONTENT_PATH_DEFAULT_DEPONIA2_HUMBLE='Chaos on Deponia'
CONTENT_PATH_DEFAULT_DEPONIA3_GOG='data/noarch/game'
CONTENT_PATH_DEFAULT_DEPONIA3_HUMBLE='Goodbye Deponia'

APP_MAIN_ICON_DEPONIA1_GOG='../support/icon.png'
APP_MAIN_ICON_DEPONIA2_GOG='../support/icon.png'
APP_MAIN_ICON_DEPONIA3_GOG='../support/icon.png'

PKG_BIN_ARCH='64'

## Deponia 1 - Ensure smooth upgrades from packages generated with 20231005.1 scripts
PKG_BIN_PROVIDES_DEPONIA1='
deponia'
PKG_DATA_PROVIDES_DEPONIA1='
deponia-1-videos
deponia-videos
deponia-data'

## Deponia 2 - Ensure smooth upgrades from packages generated with 20231005.1 scripts
PKG_DATA_PROVIDES_DEPONIA2='
deponia-2-videos'

## Deponia 3 - Ensure smooth upgrades from packages generated with 20231005.1 scripts
PKG_DATA_PROVIDES_DEPONIA3='
deponia-3-videos'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
